/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.util.Bytes;
import org.infinispan.loaders.hbase.EmbeddedServerHelper;
import org.infinispan.loaders.hbase.HBaseException;
import org.infinispan.loaders.hbase.HBaseFacade;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"manual"}, testName="loaders.hbase.HBaseFacadeTest")
public class HBaseFacadeTest {
    private static final boolean USE_EMBEDDED = true;
    private static HBaseFacade HBF;
    private static final String TABLE_MESSAGE;
    private static final String COL_FAMILY_DATA = "data";
    private static final String COL_FAMILY_METADATA = "metadata";
    private static final String QUANTIFIER_VALUE = "value";
    private static List<String> COL_FAMILIES;
    private List<String> COL_FAMILIES_WITH_DATA = new ArrayList<String>();
    private Map<String, Map<String, byte[]>> DATA_MAP_1 = new HashMap<String, Map<String, byte[]>>(1);
    private Map<String, byte[]> DATA_CELLS_1 = new HashMap<String, byte[]>();
    private Map<String, byte[]> METADATA_CELLS_1 = new HashMap<String, byte[]>();
    private Map<String, Map<String, byte[]>> DATA_MAP_2 = new HashMap<String, Map<String, byte[]>>(1);
    private Map<String, byte[]> DATA_CELLS_2 = new HashMap<String, byte[]>();
    private Map<String, Map<String, byte[]>> DATA_MAP_3 = new HashMap<String, Map<String, byte[]>>(1);
    private Map<String, byte[]> DATA_CELLS_3 = new HashMap<String, byte[]>();
    private Map<String, Map<String, byte[]>> DATA_MAP_4 = new HashMap<String, Map<String, byte[]>>(1);
    private Map<String, byte[]> DATA_CELLS_4 = new HashMap<String, byte[]>();
    private byte[] data1 = "<message><name>data1</name><value>something1</value></message>".getBytes();
    private String metadataStr1 = "<metadata><field><name>field1.1</name><value>blue1</value></field><field><name>field1.2</name><value>orange1</value></field><field><name>field1.3</name><value>purple1</value></field></metadata>";
    private byte[] metadata1 = this.metadataStr1.getBytes();
    private byte[] data2 = "<message><name>data2</name><value>something2</value></message>".getBytes();
    private byte[] data3 = "<message><name>data3</name><value>something3</value></message>".getBytes();
    private byte[] data4 = "<message><name>data4</name><value>something4</value></message>".getBytes();
    private String messageKey1 = "message1";
    private String messageKey2 = "message2";
    private String messageKey3 = "message3";
    private String messageKey4 = "message4";
    private static final String EXP_KEY_PREFIX = "exp_";
    private static final String COL_FAMILY_EXP = "expiration";
    private static final String EXP_VALUE_FIELD = "v";
    private static EmbeddedServerHelper embedded;

    @BeforeClass
    public void setup() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hbase.zookeeper.property.clientPort", Integer.toString(EmbeddedServerHelper.zooKeeperPort));
        System.out.println("************************");
        HBF = new HBaseFacade(props);
        this.COL_FAMILIES_WITH_DATA.add(COL_FAMILY_DATA);
        this.COL_FAMILIES_WITH_DATA.add(COL_FAMILY_METADATA);
        this.DATA_CELLS_1.put(QUANTIFIER_VALUE, this.data1);
        this.DATA_MAP_1.put(COL_FAMILY_DATA, this.DATA_CELLS_1);
        this.METADATA_CELLS_1.put(QUANTIFIER_VALUE, this.metadata1);
        this.DATA_MAP_1.put(COL_FAMILY_METADATA, this.METADATA_CELLS_1);
        this.DATA_CELLS_2.put(QUANTIFIER_VALUE, this.data2);
        this.DATA_MAP_2.put(COL_FAMILY_DATA, this.DATA_CELLS_2);
        this.DATA_CELLS_3.put(QUANTIFIER_VALUE, this.data3);
        this.DATA_MAP_3.put(COL_FAMILY_DATA, this.DATA_CELLS_3);
        this.DATA_CELLS_4.put(QUANTIFIER_VALUE, this.data4);
        this.DATA_MAP_4.put(COL_FAMILY_DATA, this.DATA_CELLS_4);
        COL_FAMILIES.add(COL_FAMILY_DATA);
        COL_FAMILIES.add(COL_FAMILY_METADATA);
        COL_FAMILIES.add(COL_FAMILY_EXP);
        HBF.createTable(TABLE_MESSAGE, COL_FAMILIES);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        HBF.deleteTable(TABLE_MESSAGE);
    }

    public void tableCreateAndDelete() throws HBaseException {
        String testCF = "testCF";
        String testDataVal = "This is some data.";
        String testTable = TABLE_MESSAGE + "_test";
        String testField = "testField";
        String testKey = "testKey";
        List<String> colFamilies = Collections.singletonList(testCF);
        assert (!HBF.tableExists(testTable)) : "Table already exists.";
        try {
            HBF.createTable(testTable, colFamilies);
        }
        catch (HBaseException ex) {
            if (ex.getCause() instanceof TableExistsException) {
                System.err.println("Cannot test createTable because the " + testTable + " table already exists.");
                return;
            }
            throw ex;
        }
        assert (HBF.tableExists(testTable)) : "Table not created properly.";
        Map<String, byte[]> dataCells1 = Collections.singletonMap(testField, testDataVal.getBytes());
        Map testData = Collections.singletonMap(colFamilies.get(0), dataCells1);
        HBF.addRow(testTable, testKey, testData);
        testData = HBF.readRow(testTable, testKey, colFamilies);
        assert (Arrays.equals((byte[])((Map)testData.get(colFamilies.get(0))).get(testField), testDataVal.getBytes()));
        HBF.removeRow(testTable, testKey);
        HBF.deleteTable(testTable);
        assert (!HBF.tableExists(testTable)) : "Table not deleted properly.";
    }

    public void writeAddRow() throws HBaseException {
        HBF.addRow(TABLE_MESSAGE, this.messageKey1, this.DATA_MAP_1);
        Map resultMap = HBF.readRow(TABLE_MESSAGE, this.messageKey1, this.COL_FAMILIES_WITH_DATA);
        assert (resultMap.containsKey(COL_FAMILY_DATA));
        Map columnFamilyData = (Map)resultMap.get(COL_FAMILY_DATA);
        byte[] resultData = (byte[])columnFamilyData.get(QUANTIFIER_VALUE);
        assert (Arrays.equals(resultData, this.data1));
        assert (resultMap.containsKey(COL_FAMILY_METADATA));
        Map columnFamilyMetadata = (Map)resultMap.get(COL_FAMILY_METADATA);
        byte[] resultMetadata = (byte[])columnFamilyMetadata.get(QUANTIFIER_VALUE);
        assert (Arrays.equals(resultMetadata, this.metadata1));
        HBF.removeRow(TABLE_MESSAGE, this.messageKey1);
        resultMap = HBF.readRow(TABLE_MESSAGE, this.messageKey1, this.COL_FAMILIES_WITH_DATA);
        assert (resultMap.isEmpty());
    }

    public void writeAndScanMessageData() throws HBaseException {
        HBF.addRow(TABLE_MESSAGE, this.messageKey1, this.DATA_MAP_1);
        HBF.addRow(TABLE_MESSAGE, this.messageKey2, this.DATA_MAP_2);
        HBF.addRow(TABLE_MESSAGE, this.messageKey3, this.DATA_MAP_3);
        HBF.addRow(TABLE_MESSAGE, this.messageKey4, this.DATA_MAP_4);
        Map dataMap = HBF.scan(TABLE_MESSAGE, 4, COL_FAMILY_DATA, QUANTIFIER_VALUE);
        assert (Arrays.equals((byte[])dataMap.get(this.messageKey1), this.data1));
        assert (Arrays.equals((byte[])dataMap.get(this.messageKey2), this.data2));
        assert (Arrays.equals((byte[])dataMap.get(this.messageKey3), this.data3));
        assert (Arrays.equals((byte[])dataMap.get(this.messageKey4), this.data4));
        HBF.removeRow(TABLE_MESSAGE, this.messageKey1);
        HBF.removeRow(TABLE_MESSAGE, this.messageKey2);
        HBF.removeRow(TABLE_MESSAGE, this.messageKey3);
        HBF.removeRow(TABLE_MESSAGE, this.messageKey4);
    }

    public void writeAndScanMessageKeys() throws HBaseException {
        HBF.addRow(TABLE_MESSAGE, this.messageKey1, this.DATA_MAP_1);
        HBF.addRow(TABLE_MESSAGE, this.messageKey2, this.DATA_MAP_2);
        HBF.addRow(TABLE_MESSAGE, this.messageKey3, this.DATA_MAP_3);
        HBF.addRow(TABLE_MESSAGE, this.messageKey4, this.DATA_MAP_4);
        Set keys = HBF.scanForKeys(TABLE_MESSAGE);
        assert (keys.contains(this.messageKey1)) : "Did not return a key";
        assert (keys.contains(this.messageKey2)) : "Did not return a key";
        assert (keys.contains(this.messageKey3)) : "Did not return a key";
        assert (keys.contains(this.messageKey4)) : "Did not return a key";
        HBF.removeRow(TABLE_MESSAGE, this.messageKey1);
        HBF.removeRow(TABLE_MESSAGE, this.messageKey2);
        HBF.removeRow(TABLE_MESSAGE, this.messageKey3);
        HBF.removeRow(TABLE_MESSAGE, this.messageKey4);
    }

    public void writeAndRemoveRows() throws HBaseException {
        HBF.addRow(TABLE_MESSAGE, this.messageKey1, this.DATA_MAP_1);
        HBF.addRow(TABLE_MESSAGE, this.messageKey2, this.DATA_MAP_2);
        HBF.addRow(TABLE_MESSAGE, this.messageKey3, this.DATA_MAP_3);
        HBF.addRow(TABLE_MESSAGE, this.messageKey4, this.DATA_MAP_4);
        HashSet<String> keys = new HashSet<String>();
        keys.add(this.messageKey1);
        keys.add(this.messageKey2);
        keys.add(this.messageKey3);
        keys.add(this.messageKey4);
        HBF.removeRows(TABLE_MESSAGE, keys);
        Map resultMap = HBF.readRow(TABLE_MESSAGE, this.messageKey1, this.COL_FAMILIES_WITH_DATA);
        assert (resultMap.isEmpty());
        resultMap = HBF.readRow(TABLE_MESSAGE, this.messageKey2, this.COL_FAMILIES_WITH_DATA);
        assert (resultMap.isEmpty());
        resultMap = HBF.readRow(TABLE_MESSAGE, this.messageKey3, this.COL_FAMILIES_WITH_DATA);
        assert (resultMap.isEmpty());
        resultMap = HBF.readRow(TABLE_MESSAGE, this.messageKey4, this.COL_FAMILIES_WITH_DATA);
        assert (resultMap.isEmpty());
    }

    public void readRowsAndDelete() throws HBaseException {
        String targetKey;
        byte[] targetKeyBytes;
        long tsBase = System.currentTimeMillis();
        HashSet<String> expKeys = new HashSet<String>();
        List<String> expColFamilies = Collections.singletonList(COL_FAMILY_EXP);
        HBF.addRow(TABLE_MESSAGE, this.messageKey1, this.DATA_MAP_1);
        String expKey1 = EXP_KEY_PREFIX + String.valueOf(tsBase);
        expKeys.add(expKey1);
        HBF.addRow(TABLE_MESSAGE, expKey1, this.makeExpirationMap(this.messageKey1));
        HBF.addRow(TABLE_MESSAGE, this.messageKey2, this.DATA_MAP_2);
        String expKey2 = EXP_KEY_PREFIX + String.valueOf(tsBase + 2L);
        expKeys.add(expKey2);
        HBF.addRow(TABLE_MESSAGE, expKey2, this.makeExpirationMap(this.messageKey2));
        HBF.addRow(TABLE_MESSAGE, this.messageKey3, this.DATA_MAP_3);
        String expKey3 = EXP_KEY_PREFIX + String.valueOf(tsBase + 4L);
        expKeys.add(expKey3);
        HBF.addRow(TABLE_MESSAGE, expKey3, this.makeExpirationMap(this.messageKey3));
        HBF.addRow(TABLE_MESSAGE, this.messageKey4, this.DATA_MAP_4);
        String expKey4 = EXP_KEY_PREFIX + String.valueOf(tsBase + 6L);
        expKeys.add(expKey4);
        HBF.addRow(TABLE_MESSAGE, expKey4, this.makeExpirationMap(this.messageKey4));
        Map rowsToPurge = HBF.readRows(TABLE_MESSAGE, EXP_KEY_PREFIX, tsBase + 3L, COL_FAMILY_EXP, EXP_VALUE_FIELD);
        HashSet<String> keysToDelete = new HashSet<String>();
        HashSet expKeysToDelete = new HashSet();
        for (Map.Entry entry : rowsToPurge.entrySet()) {
            assert (expKeys.contains(entry.getKey()));
            expKeysToDelete.add(entry.getKey());
            targetKeyBytes = (byte[])((Map)((Map)entry.getValue()).get(COL_FAMILY_EXP)).get(EXP_VALUE_FIELD);
            targetKey = Bytes.toString((byte[])targetKeyBytes);
            keysToDelete.add(targetKey);
        }
        assert (keysToDelete.contains(this.messageKey1));
        assert (keysToDelete.contains(this.messageKey2));
        assert (!keysToDelete.contains(this.messageKey3));
        assert (!keysToDelete.contains(this.messageKey4));
        rowsToPurge = HBF.readRows(TABLE_MESSAGE, EXP_KEY_PREFIX, tsBase + 100L, COL_FAMILY_EXP, EXP_VALUE_FIELD);
        keysToDelete = new HashSet();
        expKeysToDelete = new HashSet();
        for (Map.Entry entry : rowsToPurge.entrySet()) {
            assert (expKeys.contains(entry.getKey()));
            expKeysToDelete.add(entry.getKey());
            targetKeyBytes = (byte[])((Map)((Map)entry.getValue()).get(COL_FAMILY_EXP)).get(EXP_VALUE_FIELD);
            targetKey = Bytes.toString((byte[])targetKeyBytes);
            keysToDelete.add(targetKey);
        }
        assert (keysToDelete.contains(this.messageKey1));
        assert (keysToDelete.contains(this.messageKey2));
        assert (keysToDelete.contains(this.messageKey3));
        assert (keysToDelete.contains(this.messageKey4));
        HBF.removeRows(TABLE_MESSAGE, keysToDelete);
        HBF.removeRows(TABLE_MESSAGE, expKeysToDelete);
        Map resultMap = HBF.readRow(TABLE_MESSAGE, this.messageKey1, this.COL_FAMILIES_WITH_DATA);
        assert (resultMap.isEmpty());
        resultMap = HBF.readRow(TABLE_MESSAGE, expKey1, expColFamilies);
        assert (resultMap.isEmpty());
        resultMap = HBF.readRow(TABLE_MESSAGE, this.messageKey2, this.COL_FAMILIES_WITH_DATA);
        assert (resultMap.isEmpty());
        resultMap = HBF.readRow(TABLE_MESSAGE, expKey2, expColFamilies);
        assert (resultMap.isEmpty());
        resultMap = HBF.readRow(TABLE_MESSAGE, this.messageKey3, this.COL_FAMILIES_WITH_DATA);
        assert (resultMap.isEmpty());
        resultMap = HBF.readRow(TABLE_MESSAGE, expKey3, expColFamilies);
        assert (resultMap.isEmpty());
        resultMap = HBF.readRow(TABLE_MESSAGE, this.messageKey4, this.COL_FAMILIES_WITH_DATA);
        assert (resultMap.isEmpty());
        resultMap = HBF.readRow(TABLE_MESSAGE, expKey4, expColFamilies);
        assert (resultMap.isEmpty());
    }

    private Map<String, Map<String, byte[]>> makeExpirationMap(String value) {
        Map<String, byte[]> expValMap = Collections.singletonMap(EXP_VALUE_FIELD, Bytes.toBytes((String)value));
        Map<String, Map<String, byte[]>> expCfMap = Collections.singletonMap(COL_FAMILY_EXP, expValMap);
        return expCfMap;
    }

    static {
        TABLE_MESSAGE = "messages_" + System.currentTimeMillis();
        COL_FAMILIES = new ArrayList<String>();
        embedded = null;
        embedded = new EmbeddedServerHelper();
        try {
            embedded.setup();
        }
        catch (Exception ex) {
            System.err.println(ex.getClass().getName() + " occured starting " + "up embedded HBase server: " + ex.getMessage());
        }
    }
}

