/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.hbase.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.loaders.hbase.configuration.HBaseCacheStoreConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.hbase.configuration.XmlFileParsingTest")
public class XmlFileParsingTest
extends AbstractInfinispanTest {
    private EmbeddedCacheManager cacheManager;

    @AfterMethod(alwaysRun=true)
    public void cleanup() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testRemoteCacheStore() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.2 http://www.infinispan.org/schemas/infinispan-config-5.2.xsd\"\n      xmlns=\"urn:infinispan:config:5.2\">   <default>\n     <loaders>\n       <hbaseStore xmlns=\"urn:infinispan:config:hbase:5.2\" fetchPersistentState=\"true\" autoCreateTable=\"false\" entryColumnFamily=\"ECF\" entryTable=\"ET\"          entryValueField=\"EVF\" expirationColumnFamily=\"XCF\" expirationTable=\"XT\" expirationValueField=\"XVF\" hbaseZookeeperQuorumHost=\"myhost\" hbaseZookeeperClientPort=\"4321\" sharedTable=\"true\">\n         <async enabled=\"true\" />\n       </hbaseStore>\n     </loaders>\n   </default>\n</infinispan>";
        HBaseCacheStoreConfiguration store = (HBaseCacheStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        assert (!store.autoCreateTable());
        assert (store.entryColumnFamily().equals("ECF"));
        assert (store.entryTable().equals("ET"));
        assert (store.entryValueField().equals("EVF"));
        assert (store.expirationColumnFamily().equals("XCF"));
        assert (store.expirationTable().equals("XT"));
        assert (store.expirationValueField().equals("XVF"));
        assert (store.hbaseZookeeperQuorumHost().equals("myhost"));
        assert (store.hbaseZookeeperClientPort() == 4321);
        assert (store.sharedTable());
        assert (store.fetchPersistentState());
        assert (store.async().enabled());
    }

    private CacheLoaderConfiguration buildCacheManagerWithCacheStore(String config) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        assert (this.cacheManager.getDefaultCacheConfiguration().loaders().cacheLoaders().size() == 1);
        return (CacheLoaderConfiguration)this.cacheManager.getDefaultCacheConfiguration().loaders().cacheLoaders().get(0);
    }
}

