/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.hbase.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    AUTO_CREATE_TABLE("autoCreateTable"),
    ENTRY_COLUMN_FAMILY("entryColumnFamily"),
    ENTRY_TABLE("entryTable"),
    ENTRY_VALUE_FIELD("entryValueField"),
    EXPIRATION_COLUMN_FAMILY("expirationColumnFamily"),
    EXPIRATION_TABLE("expirationTable"),
    EXPIRATION_VALUE_FIELD("expirationValueField"),
    HBASE_ZOOKEEPER_QUORUM_HOST("hbaseZookeeperQuorumHost"),
    HBASE_ZOOKEEPER_CLIENT_PORT("hbaseZookeeperClientPort"),
    KEY_MAPPER("keyMapper"),
    SHARED_TABLE("sharedTable");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

