/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.hbase.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser52;
import org.infinispan.loaders.hbase.configuration.Attribute;
import org.infinispan.loaders.hbase.configuration.Element;
import org.infinispan.loaders.hbase.configuration.HBaseCacheStoreConfigurationBuilder;
import org.infinispan.util.StringPropertyReplacer;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class HBaseCacheStoreConfigurationParser52
implements ConfigurationParser<ConfigurationBuilderHolder> {
    private static final Namespace[] NAMESPACES = new Namespace[]{new Namespace("urn:infinispan:config", "hbase", Element.HBASE_STORE.getLocalName(), 5, 2)};

    public Namespace[] getSupportedNamespaces() {
        return NAMESPACES;
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case HBASE_STORE: {
                this.parseHBaseStore(reader, builder.loaders(), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseHBaseStore(XMLExtendedStreamReader reader, LoadersConfigurationBuilder loadersBuilder, ClassLoader classLoader) throws XMLStreamException {
        HBaseCacheStoreConfigurationBuilder builder = new HBaseCacheStoreConfigurationBuilder(loadersBuilder);
        this.parseHBaseStoreAttributes(reader, builder);
        while (reader.hasNext() && reader.nextTag() != 2) {
            Parser52.parseCommonStoreChildren((XMLExtendedStreamReader)reader, (CacheStoreConfigurationBuilder)builder);
        }
        loadersBuilder.addStore((CacheStoreConfigurationBuilder)builder);
    }

    private void parseHBaseStoreAttributes(XMLExtendedStreamReader reader, HBaseCacheStoreConfigurationBuilder builder) throws XMLStreamException {
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUTO_CREATE_TABLE: {
                    builder.autoCreateTable(Boolean.parseBoolean(value));
                    continue block13;
                }
                case ENTRY_COLUMN_FAMILY: {
                    builder.entryColumnFamily(value);
                    continue block13;
                }
                case ENTRY_TABLE: {
                    builder.entryTable(value);
                    continue block13;
                }
                case ENTRY_VALUE_FIELD: {
                    builder.entryValueField(value);
                    continue block13;
                }
                case EXPIRATION_COLUMN_FAMILY: {
                    builder.expirationColumnFamily(value);
                    continue block13;
                }
                case EXPIRATION_TABLE: {
                    builder.expirationTable(value);
                    continue block13;
                }
                case EXPIRATION_VALUE_FIELD: {
                    builder.expirationValueField(value);
                    continue block13;
                }
                case HBASE_ZOOKEEPER_QUORUM_HOST: {
                    builder.hbaseZookeeperQuorumHost(value);
                    continue block13;
                }
                case HBASE_ZOOKEEPER_CLIENT_PORT: {
                    builder.hbaseZookeeperClientPort(Integer.parseInt(value));
                    continue block13;
                }
                case KEY_MAPPER: {
                    builder.keyMapper(value);
                    continue block13;
                }
                case SHARED_TABLE: {
                    builder.sharedTable(Boolean.parseBoolean(value));
                    continue block13;
                }
                default: {
                    Parser52.parseCommonStoreAttributes((XMLExtendedStreamReader)reader, (int)i, (CacheStoreConfigurationBuilder)builder);
                }
            }
        }
    }
}

