/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.hbase;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.loaders.hbase.test.HBaseCluster;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"manual"}, testName="loaders.hbase.HBaseCacheStoreStandaloneTest")
public class HBaseCacheStoreStandaloneTest
extends SingleCacheManagerTest {
    private static final boolean USE_EMBEDDED = true;
    private static final String[] keys = new String[]{"message1", "message2", "message3", "message4", "message5"};
    private static final StringObject[] stringObjects = new StringObject[]{new StringObject("color", "red", keys[0]), new StringObject("color", "blue", keys[1]), new StringObject("color", "green", keys[2]), new StringObject("color", "black", keys[3]), new StringObject("color", "purple", keys[4])};
    private static Cache<Object, Object> CACHE = null;
    private HBaseCluster hBaseCluster;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        System.setProperty("java.net.preferIPv4Stack", "true");
        return TestCacheManagerFactory.fromXml((String)"hbase-cachestore-ispn-embedded.xml");
    }

    protected void setup() throws Exception {
        this.hBaseCluster = new HBaseCluster();
        super.setup();
    }

    protected void teardown() {
        super.teardown();
        HBaseCluster.shutdown(this.hBaseCluster);
    }

    public void testCache() throws Exception {
        assert (CACHE.isEmpty());
        try {
            int i;
            for (int i2 = 0; i2 < keys.length; ++i2) {
                CACHE.put((Object)keys[i2], (Object)stringObjects[i2]);
            }
            assert (CACHE.size() == keys.length);
            Set storedKeys = CACHE.keySet();
            assert (storedKeys.size() == keys.length);
            for (String key : keys) {
                assert (storedKeys.contains(key));
            }
            Set storedObjects = CACHE.entrySet();
            assert (storedObjects.size() == keys.length);
            ArrayList objects = new ArrayList();
            for (Map.Entry entry : storedObjects) {
                objects.add(entry.getValue());
            }
            for (i = 0; i < keys.length; ++i) {
                assert (objects.contains(stringObjects[i]));
            }
            for (i = 0; i < keys.length; ++i) {
                assert (CACHE.containsKey((Object)keys[i]));
                Object val = CACHE.get((Object)keys[i]);
                assert (val != null);
                assert (stringObjects[i].toString().equals(val.toString()));
                CACHE.remove((Object)keys[i]);
                val = CACHE.get((Object)keys[i]);
                assert (val == null);
            }
        }
        catch (Exception ex) {
            System.err.println("Caught exception: " + ex.getMessage());
            ex.printStackTrace();
            throw ex;
        }
    }

    public void testRemove() throws Exception {
        int i;
        for (i = 0; i < keys.length; ++i) {
            CACHE.put((Object)keys[i], (Object)stringObjects[i]);
        }
        for (i = 0; i < keys.length; ++i) {
            assert (CACHE.containsKey((Object)keys[i]));
            Object val = CACHE.get((Object)keys[i]);
            assert (stringObjects[i].toString().equals(val.toString()));
        }
        boolean result = CACHE.remove((Object)keys[0], (Object)stringObjects[0]);
        assert (result);
        result = CACHE.remove((Object)"zzz", (Object)stringObjects[0]);
        assert (!result);
    }

    public void testPutAll() throws Exception {
        int i;
        HashMap<String, StringObject> cacheMap = new HashMap<String, StringObject>();
        for (i = 0; i < keys.length; ++i) {
            cacheMap.put(keys[i], stringObjects[i]);
        }
        CACHE.putAll(cacheMap);
        for (i = 0; i < keys.length; ++i) {
            assert (CACHE.containsKey((Object)keys[i]));
            Object val = CACHE.get((Object)keys[i]);
            assert (stringObjects[i].toString().equals(val.toString()));
        }
    }

    public void testClear() throws Exception {
        for (int i = 0; i < keys.length; ++i) {
            CACHE.put((Object)keys[i], (Object)stringObjects[i]);
        }
        for (String key : keys) {
            assert (CACHE.containsKey((Object)key));
        }
        CACHE.clear();
        for (String key : keys) {
            assert (!CACHE.containsKey((Object)key));
        }
        assert (CACHE.keySet().size() == 0);
    }

    public void testReplace() throws Exception {
        CACHE.put((Object)keys[0], (Object)stringObjects[0]);
        Object val = CACHE.get((Object)keys[0]);
        assert (val != null);
        assert (stringObjects[0].toString().equals(val.toString()));
        CACHE.replace((Object)keys[0], (Object)stringObjects[1]);
        val = CACHE.get((Object)keys[0]);
        assert (val != null);
        assert (stringObjects[1].toString().equals(val.toString()));
        CACHE.remove((Object)keys[0]);
    }

    static class StringObject
    implements Serializable {
        private static final long serialVersionUID = 254191608570966230L;
        protected final String key;
        protected final String value;
        protected final String docId;

        public StringObject(String key, String value, String docId) {
            this.key = key;
            this.value = value;
            this.docId = docId;
        }

        public String toString() {
            return this.key + "[" + this.value + "]" + (this.docId != null ? "-->" + this.docId : "");
        }
    }
}

