/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.hbase.test;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class HBaseCluster {
    private static final Log log = LogFactory.getLog(HBaseCluster.class);
    private static final ThreadLocal<Integer> masterPort = new ThreadLocal<Integer>(){
        private final AtomicInteger port = new AtomicInteger(61010);

        @Override
        protected Integer initialValue() {
            return this.port.getAndAdd(100);
        }
    };
    private final HBaseTestingUtility testUtil;
    private final int zooKeeperPort;

    public HBaseCluster() {
        log.info((Object)"Starting HBase cluster");
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.master.assignment.timeoutmonitor.period", 2000);
        conf.setInt("hbase.master.assignment.timeoutmonitor.timeout", 5000);
        conf.setInt("hbase.master.info.port", masterPort.get().intValue());
        conf.set("hbase.master.dns.interface", "lo");
        conf.set("hbase.regionserver.dns.interface", "lo");
        this.testUtil = new HBaseTestingUtility(conf);
        try {
            try {
                this.testUtil.startMiniCluster();
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("Hadoop expects default umask to be 022, seems like your system has a different one", e);
            }
            MiniHBaseCluster cluster = this.testUtil.getHBaseCluster();
            log.info((Object)"Waiting for active/ready HBase master");
            cluster.waitForActiveAndReadyMaster();
            this.zooKeeperPort = this.testUtil.getConfiguration().getInt("hbase.zookeeper.property.clientPort", -1);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start HBase cluster", e);
        }
    }

    public int getZooKeeperPort() {
        return this.zooKeeperPort;
    }

    private void shutdown() {
        try {
            this.testUtil.shutdownMiniCluster();
        }
        catch (Exception e) {
            log.warn((Object)"Problems shutting down HBase cluster", (Throwable)e);
        }
    }

    public static void shutdown(HBaseCluster hbaseCluster) {
        if (hbaseCluster != null) {
            hbaseCluster.shutdown();
        }
    }
}

