/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbm;

import java.io.IOException;
import jdbm.helper.Serializer;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JdbmSerializer
implements Serializer {
    private static final Log log = LogFactory.getLog(JdbmSerializer.class);
    private transient StreamingMarshaller marshaller;

    public JdbmSerializer(StreamingMarshaller marshaller) {
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        this.marshaller = marshaller;
    }

    public Object deserialize(byte[] buf) throws IOException {
        try {
            return this.marshaller.objectFromByteBuffer(buf);
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public byte[] serialize(Object obj) throws IOException {
        try {
            return this.marshaller.objectToByteBuffer(obj);
        }
        catch (InterruptedException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Interrupted while serializing object");
            }
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }
}

