/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbm;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.jdbm.JdbmCacheStore;
import org.infinispan.loaders.jdbm.JdbmCacheStoreConfig;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.jdbm.JdbmCacheStoreTest")
public class JdbmCacheStoreTest
extends BaseCacheStoreTest {
    private JdbmCacheStore fcs;
    private String tmpDirectory;

    @BeforeClass
    protected void setUpTempDir() {
        this.tmpDirectory = TestingUtil.tmpDirectory((AbstractInfinispanTest)this);
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove((String)this.tmpDirectory);
        new File(this.tmpDirectory).mkdirs();
    }

    protected CacheStore createCacheStore() throws CacheLoaderException {
        this.clearTempDir();
        this.fcs = new JdbmCacheStore();
        JdbmCacheStoreConfig cfg = new JdbmCacheStoreConfig();
        cfg.setLocation(this.tmpDirectory);
        cfg.setPurgeSynchronously(Boolean.valueOf(true));
        this.fcs.init((CacheLoaderConfig)cfg, this.getCache(), this.getMarshaller());
        this.fcs.start();
        return this.fcs;
    }

    public void testPreload() throws Exception {
        super.testPreload();
    }

    public void testPurgeExpired() throws Exception {
        long lifespan = 1000L;
        InternalCacheEntry k1 = TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v1", (long)lifespan);
        InternalCacheEntry k2 = TestInternalCacheEntryFactory.create((Object)"k2", (Object)"v2", (long)lifespan);
        InternalCacheEntry k3 = TestInternalCacheEntryFactory.create((Object)"k3", (Object)"v3", (long)lifespan);
        this.cs.store(k1);
        this.cs.store(k2);
        this.cs.store(k3);
        assert (this.cs.containsKey((Object)"k1"));
        assert (this.cs.containsKey((Object)"k2"));
        assert (this.cs.containsKey((Object)"k3"));
        Thread.sleep(lifespan + 100L);
        this.cs.purgeExpired();
        JdbmCacheStore fcs = (JdbmCacheStore)this.cs;
        assert (fcs.load((Object)"k1") == null);
        assert (fcs.load((Object)"k2") == null);
        assert (fcs.load((Object)"k3") == null);
    }

    public void testStopStartDoesntNukeValues() throws InterruptedException, CacheLoaderException {
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        long lifespan = 1L;
        long idle = 1L;
        InternalCacheEntry se1 = TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v1", (long)lifespan);
        InternalCacheEntry se2 = TestInternalCacheEntryFactory.create((Object)"k2", (Object)"v2");
        InternalCacheEntry se3 = TestInternalCacheEntryFactory.create((Object)"k3", (Object)"v3", (long)-1L, (long)idle);
        InternalCacheEntry se4 = TestInternalCacheEntryFactory.create((Object)"k4", (Object)"v4", (long)lifespan, (long)idle);
        this.cs.store(se1);
        this.cs.store(se2);
        this.cs.store(se3);
        this.cs.store(se4);
        Thread.sleep(100L);
        this.cs.purgeExpired();
        this.cs.stop();
        this.cs.start();
        assert (se1.isExpired());
        assert (this.cs.load((Object)"k1") == null);
        assert (!this.cs.containsKey((Object)"k1"));
        assert (this.cs.load((Object)"k2") != null);
        assert (this.cs.containsKey((Object)"k2"));
        assert (this.cs.load((Object)"k2").getValue().equals("v2"));
        assert (se3.isExpired());
        assert (this.cs.load((Object)"k3") == null);
        assert (!this.cs.containsKey((Object)"k3"));
        assert (se3.isExpired());
        assert (this.cs.load((Object)"k3") == null);
        assert (!this.cs.containsKey((Object)"k3"));
    }

    public void testIterator() throws Exception {
        InternalCacheEntry k1 = TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v1");
        InternalCacheEntry k2 = TestInternalCacheEntryFactory.create((Object)"k2", (Object)"v2");
        this.cs.store(k1);
        this.cs.store(k2);
        Set set = this.cs.loadAll();
        Iterator i = set.iterator();
        assert (i.hasNext());
        assert (i.hasNext());
        assert (((InternalCacheEntry)i.next()).getKey().equals("k1"));
        assert (((InternalCacheEntry)i.next()).getKey().equals("k2"));
        assert (!i.hasNext());
        assert (!i.hasNext());
        try {
            i.next();
            assert (false);
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }
}

