/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.leveldb.config;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyStoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.leveldb.LevelDBCacheStore;
import org.infinispan.loaders.leveldb.configuration.LevelDBCacheStoreConfiguration;
import org.infinispan.loaders.leveldb.configuration.LevelDBCacheStoreConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.leveldb.configuration.ConfigurationTest")
public class ConfigurationTest
extends AbstractInfinispanTest {
    private String tmpDirectory;
    private String tmpDataDirectory;
    private String tmpExpiredDirectory;

    @BeforeTest
    protected void setUpTempDir() {
        this.tmpDirectory = TestingUtil.tmpDirectory((AbstractInfinispanTest)this);
        this.tmpDataDirectory = this.tmpDirectory + "/data";
        this.tmpExpiredDirectory = this.tmpDirectory + "/expired";
    }

    @AfterTest(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove((String)this.tmpDirectory);
    }

    public void testConfigBuilder() {
        GlobalConfiguration globalConfig = new GlobalConfigurationBuilder().globalJmxStatistics().transport().defaultTransport().build();
        Configuration cacheConfig = ((LevelDBCacheStoreConfigurationBuilder)new ConfigurationBuilder().loaders().addLoader(LevelDBCacheStoreConfigurationBuilder.class)).location(this.tmpDataDirectory).expiredLocation(this.tmpExpiredDirectory).build();
        CacheLoaderConfiguration cacheLoaderConfig = (CacheLoaderConfiguration)cacheConfig.loaders().cacheLoaders().get(0);
        AssertJUnit.assertTrue((boolean)(cacheLoaderConfig instanceof LevelDBCacheStoreConfiguration));
        LevelDBCacheStoreConfiguration leveldbConfig = (LevelDBCacheStoreConfiguration)cacheLoaderConfig;
        AssertJUnit.assertEquals((String)this.tmpDataDirectory, (String)leveldbConfig.location());
        AssertJUnit.assertEquals((String)this.tmpExpiredDirectory, (String)leveldbConfig.expiredLocation());
        DefaultCacheManager cacheManager = new DefaultCacheManager(globalConfig);
        cacheManager.defineConfiguration("testCache", cacheConfig);
        cacheManager.start();
        Cache cache = cacheManager.getCache("testCache");
        cache.put((Object)"hello", (Object)"there");
        cache.stop();
        cacheManager.stop();
    }

    public void testLegacyJavaConfig() {
        GlobalConfiguration globalConfig = new GlobalConfigurationBuilder().globalJmxStatistics().transport().defaultTransport().build();
        Configuration cacheConfig = ((LegacyStoreConfigurationBuilder)((LegacyStoreConfigurationBuilder)new ConfigurationBuilder().loaders().addStore().cacheStore((CacheStore)new LevelDBCacheStore()).addProperty("location", this.tmpDataDirectory)).addProperty("expiredLocation", this.tmpExpiredDirectory)).build();
        DefaultCacheManager cacheManager = new DefaultCacheManager(globalConfig);
        cacheManager.defineConfiguration("testCache", cacheConfig);
        cacheManager.start();
        Cache cache = cacheManager.getCache("testCache");
        cache.put((Object)"hello", (Object)"there legacy java");
        cache.stop();
        cacheManager.stop();
    }

    public void textXmlConfigLegacy() throws IOException {
        DefaultCacheManager cacheManager = new DefaultCacheManager("config/leveldb-config-legacy.xml");
        Cache cache = cacheManager.getCache("testCache");
        cache.put((Object)"hello", (Object)"there legacy xml");
        cache.stop();
        cacheManager.stop();
        TestingUtil.recursiveFileRemove((String)"/tmp/leveldb/legacy");
    }

    public void testXmlConfig52() throws IOException {
        DefaultCacheManager cacheManager = new DefaultCacheManager("config/leveldb-config-52.xml");
        Cache cache = cacheManager.getCache("testCache");
        cache.put((Object)"hello", (Object)"there 52 xml");
        cache.stop();
        cacheManager.stop();
        TestingUtil.recursiveFileRemove((String)"/tmp/leveldb/52");
    }
}

