/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.leveldb;

import java.io.File;
import org.infinispan.loaders.BaseCacheStoreFunctionalTest;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.leveldb.LevelDBCacheStoreConfig;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.leveldb.LevelDBCacheStoreFunctionalTest")
public class LevelDBCacheStoreFunctionalTest
extends BaseCacheStoreFunctionalTest {
    private String tmpDirectory;

    @BeforeClass
    protected void setUpTempDir() {
        this.tmpDirectory = TestingUtil.tmpDirectory((AbstractInfinispanTest)this);
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove((String)this.tmpDirectory);
        new File(this.tmpDirectory).mkdirs();
    }

    protected CacheStoreConfig createCacheStoreConfig() throws CacheLoaderException {
        LevelDBCacheStoreConfig cfg = new LevelDBCacheStoreConfig();
        cfg.setLocation(this.tmpDirectory + "/data");
        cfg.setExpiredLocation(this.tmpDirectory + "/expiry");
        cfg.setClearThreshold(2);
        cfg.setPurgeSynchronously(Boolean.valueOf(true));
        return cfg;
    }
}

