/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.leveldb;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.concurrent.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.LockSupportCacheStore;
import org.infinispan.loaders.leveldb.LevelDBCacheStoreConfig;
import org.infinispan.loaders.leveldb.logging.Log;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.logging.LogFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.impl.Iq80DBFactory;

@CacheLoaderMetadata(configurationClass=LevelDBCacheStoreConfig.class)
@ThreadSafe
public class LevelDBCacheStore
extends LockSupportCacheStore<Integer> {
    private static final Log log = (Log)LogFactory.getLog(LevelDBCacheStore.class, Log.class);
    private LevelDBCacheStoreConfig config;
    private BlockingQueue<ExpiryEntry> expiryEntryQueue;
    private DB db;
    private DB expiredDb;

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return LevelDBCacheStoreConfig.class;
    }

    public void init(CacheLoaderConfig config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(config, cache, m);
        this.config = (LevelDBCacheStoreConfig)config;
    }

    public void start() throws CacheLoaderException {
        this.expiryEntryQueue = new LinkedBlockingQueue<ExpiryEntry>(this.config.getExpiryQueueSize());
        try {
            this.db = this.openDatabase(this.config.getLocation(), this.config.getDataDbOptions());
            this.expiredDb = this.openDatabase(this.config.getExpiredLocation(), this.config.getExpiredDbOptions());
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to open database", (Throwable)e);
        }
        super.start();
    }

    protected DB openDatabase(String location, Options options) throws IOException {
        return Iq80DBFactory.factory.open(new File(location), options);
    }

    protected void destroyDatabase(String location) throws IOException {
        File dir = new File(location);
        Iq80DBFactory.factory.destroy(dir, null);
    }

    protected DB reinitDatabase(String location, Options options) throws IOException {
        this.destroyDatabase(location);
        return this.openDatabase(location, options);
    }

    protected void reinitAllDatabases() throws IOException {
        this.db = this.reinitDatabase(this.config.getLocation(), this.config.getDataDbOptions());
        this.expiredDb = this.reinitDatabase(this.config.getExpiredLocation(), this.config.getExpiredDbOptions());
    }

    public void stop() throws CacheLoaderException {
        try {
            this.db.close();
        }
        catch (IOException e) {
            log.warnUnableToCloseDb(e);
        }
        try {
            this.expiredDb.close();
        }
        catch (IOException e) {
            log.warnUnableToCloseExpiredDb(e);
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearLockSafe() throws CacheLoaderException {
        long count = 0L;
        DBIterator it = this.db.iterator(new ReadOptions().fillCache(false));
        boolean destroyDatabase = false;
        if (this.config.getClearThreshold() <= 0) {
            try {
                it.seekToFirst();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    this.db.delete((byte[])entry.getKey());
                    if (++count <= (long)this.config.clearThreshold) continue;
                    destroyDatabase = true;
                }
            }
            finally {
                try {
                    it.close();
                }
                catch (IOException e) {
                    log.warnUnableToCloseDbIterator(e);
                }
            }
        } else {
            destroyDatabase = true;
        }
        if (destroyDatabase) {
            try {
                this.reinitAllDatabases();
            }
            catch (IOException e) {
                throw new CacheLoaderException((Throwable)e);
            }
        }
    }

    protected Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException {
        HashSet<InternalCacheEntry> entries = new HashSet<InternalCacheEntry>();
        DBIterator it = this.db.iterator(new ReadOptions().fillCache(false));
        try {
            it.seekToFirst();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                entries.add(this.unmarshall(entry));
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            try {
                it.close();
            }
            catch (IOException e) {
                log.warnUnableToCloseDbIterator(e);
            }
        }
        return entries;
    }

    protected Set<InternalCacheEntry> loadLockSafe(int maxEntries) throws CacheLoaderException {
        if (maxEntries <= 0) {
            return Collections.emptySet();
        }
        HashSet<InternalCacheEntry> entries = new HashSet<InternalCacheEntry>();
        DBIterator it = this.db.iterator(new ReadOptions().fillCache(false));
        try {
            it.seekToFirst();
            for (int i = 0; it.hasNext() && i < maxEntries; ++i) {
                Map.Entry entry = (Map.Entry)it.next();
                entries.add(this.unmarshall(entry));
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            try {
                it.close();
            }
            catch (IOException e) {
                log.warnUnableToCloseDbIterator(e);
            }
        }
        return entries;
    }

    protected Set<Object> loadAllKeysLockSafe(Set<Object> keysToExclude) throws CacheLoaderException {
        HashSet<Object> keys = new HashSet<Object>();
        DBIterator it = this.db.iterator(new ReadOptions().fillCache(false));
        try {
            Object entry;
            it.seekToFirst();
            while (it.hasNext()) {
                entry = (Map.Entry)it.next();
                Object key = this.unmarshall((byte[])entry.getKey());
                if (keysToExclude != null && !keysToExclude.isEmpty() && keysToExclude.contains(key)) continue;
                keys.add(key);
            }
            entry = keys;
            return entry;
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            try {
                it.close();
            }
            catch (IOException e) {
                log.warnUnableToCloseDbIterator(e);
            }
        }
    }

    protected void toStreamLockSafe(ObjectOutput oos) throws CacheLoaderException {
        DBIterator it = this.db.iterator(new ReadOptions().fillCache(false));
        try {
            it.seekToFirst();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                InternalCacheEntry ice = this.unmarshall(entry);
                this.getMarshaller().objectToObjectStream((Object)ice, oos);
            }
            this.getMarshaller().objectToObjectStream(null, oos);
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            try {
                it.close();
            }
            catch (IOException e) {
                log.warnUnableToCloseDbIterator(e);
            }
        }
    }

    protected void fromStreamLockSafe(ObjectInput ois) throws CacheLoaderException {
        try {
            InternalCacheEntry entry;
            while ((entry = (InternalCacheEntry)this.getMarshaller().objectFromObjectStream(ois)) != null) {
                this.db.put(this.marshall(entry.getKey()), this.marshall(entry));
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    protected boolean removeLockSafe(Object key, Integer lockingKey) throws CacheLoaderException {
        try {
            byte[] keyBytes = this.marshall(key);
            if (this.db.get(keyBytes) == null) {
                return false;
            }
            this.db.delete(keyBytes);
            return true;
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    protected void storeLockSafe(InternalCacheEntry ed, Integer lockingKey) throws CacheLoaderException {
        try {
            this.db.put(this.marshall(ed.getKey()), this.marshall(ed));
            if (ed.canExpire()) {
                this.addNewExpiry(ed);
            }
        }
        catch (Exception e) {
            throw new DBException((Throwable)e);
        }
    }

    protected InternalCacheEntry loadLockSafe(Object key, Integer lockingKey) throws CacheLoaderException {
        try {
            InternalCacheEntry ice = this.unmarshall(this.db.get(this.marshall(key)), key);
            if (ice != null && ice.isExpired(System.currentTimeMillis())) {
                this.removeLockSafe(key, lockingKey);
                return null;
            }
            return ice;
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    protected Integer getLockFromKey(Object key) throws CacheLoaderException {
        return key.hashCode();
    }

    protected void purgeInternal() throws CacheLoaderException {
        try {
            ArrayList entries = new ArrayList();
            this.expiryEntryQueue.drainTo(entries);
            for (ExpiryEntry entry : entries) {
                byte[] expiryBytes = this.marshall(entry.expiry);
                byte[] keyBytes = this.marshall(entry.key);
                byte[] existingBytes = this.expiredDb.get(expiryBytes);
                if (existingBytes != null) {
                    Object existing = this.unmarshall(existingBytes);
                    if (existing instanceof List) {
                        ((List)existing).add(entry.key);
                        this.expiredDb.put(expiryBytes, this.marshall(existing));
                        continue;
                    }
                    ArrayList<Object> al = new ArrayList<Object>(2);
                    al.add(existing);
                    al.add(entry.key);
                    this.expiredDb.put(expiryBytes, this.marshall(al));
                    continue;
                }
                this.expiredDb.put(this.marshall(expiryBytes), keyBytes);
            }
            ArrayList<Long> times = new ArrayList<Long>();
            ArrayList<Object> keys = new ArrayList<Object>();
            DBIterator it = this.expiredDb.iterator(new ReadOptions().fillCache(false));
            try {
                Map.Entry entry;
                Long time;
                it.seekToFirst();
                while (it.hasNext() && (time = (Long)this.unmarshall((byte[])(entry = (Map.Entry)it.next()).getKey())) <= System.currentTimeMillis()) {
                    times.add(time);
                    Object key = this.unmarshall((byte[])entry.getValue());
                    if (key instanceof List) {
                        keys.addAll((List)key);
                        continue;
                    }
                    keys.add(key);
                }
                for (Long time2 : times) {
                    this.expiredDb.delete(this.marshall(time2));
                }
                if (!keys.isEmpty()) {
                    log.debugf("purge (up to) %d entries", keys.size());
                }
                int count = 0;
                long currentTimeMillis = System.currentTimeMillis();
                for (Object e : keys) {
                    InternalCacheValue ice;
                    byte[] keyBytes = this.marshall(e);
                    byte[] b = this.db.get(keyBytes);
                    if (b == null || !(ice = (InternalCacheValue)this.getMarshaller().objectFromByteBuffer(b)).isExpired(currentTimeMillis)) continue;
                    this.db.delete(keyBytes);
                    ++count;
                }
                if (count != 0) {
                    log.debugf("purged %d entries", count);
                }
            }
            catch (Exception e) {
                throw new CacheLoaderException((Throwable)e);
            }
            finally {
                try {
                    it.close();
                }
                catch (IOException e) {
                    log.warnUnableToCloseDbIterator(e);
                }
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    private byte[] marshall(InternalCacheEntry entry) throws IOException, InterruptedException {
        return this.marshall(entry.toInternalCacheValue());
    }

    private byte[] marshall(Object entry) throws IOException, InterruptedException {
        return this.getMarshaller().objectToByteBuffer(entry);
    }

    private Object unmarshall(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        return this.getMarshaller().objectFromByteBuffer(bytes);
    }

    private InternalCacheEntry unmarshall(Map.Entry<byte[], byte[]> entry) throws IOException, ClassNotFoundException {
        if (entry == null || entry.getValue() == null) {
            return null;
        }
        InternalCacheValue v = (InternalCacheValue)this.unmarshall(entry.getValue());
        Object k = this.unmarshall(entry.getKey());
        return v.toInternalCacheEntry(k);
    }

    private InternalCacheEntry unmarshall(byte[] value, Object key) throws IOException, ClassNotFoundException {
        if (value == null) {
            return null;
        }
        InternalCacheValue v = (InternalCacheValue)this.unmarshall(value);
        return v.toInternalCacheEntry(key);
    }

    private void addNewExpiry(InternalCacheEntry entry) throws IOException {
        long expiry = entry.getExpiryTime();
        if (entry.getMaxIdle() > 0L) {
            expiry = entry.getMaxIdle() + System.currentTimeMillis();
        }
        Long at = expiry;
        Object key = entry.getKey();
        try {
            this.expiryEntryQueue.put(new ExpiryEntry(at, key));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static final class ExpiryEntry {
        private final Long expiry;
        private final Object key;

        private ExpiryEntry(long expiry, Object key) {
            this.expiry = expiry;
            this.key = key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpiryEntry other = (ExpiryEntry)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }
}

