/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.leveldb;

import java.util.Properties;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.loaders.LockSupportCacheStoreConfig;
import org.infinispan.loaders.leveldb.LevelDBCacheStore;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.Options;

public class LevelDBCacheStoreConfig
extends LockSupportCacheStoreConfig {
    private static final long serialVersionUID = -6138954929695571573L;
    public static final String DEFAULT_LOCATION = "leveldb/data";
    public static final String DEFAULT_EXPIRED_LOCATION = "leveldb/expired";
    public static final CompressionType DEFAULT_COMPRESSION_TYPE = CompressionType.NONE;
    public static final int DEFAULT_EXPIRY_QUEUE_SIZE = 10000;
    public static final int DEFAULT_CLEAR_THRESHOLD = 10000;
    public static final ImplementationType DEFAULT_IMPLEMENTATION_TYPE = ImplementationType.AUTO;
    protected String location = "leveldb/data";
    protected String expiredLocation = "leveldb/expired";
    protected String compressionType = DEFAULT_COMPRESSION_TYPE.toString();
    protected Integer blockSize;
    protected Long cacheSize;
    protected String implementationType = DEFAULT_IMPLEMENTATION_TYPE.toString();
    protected int expiryQueueSize = 10000;
    protected int clearThreshold = 10000;

    public LevelDBCacheStoreConfig() {
        this.setCacheLoaderClassName(LevelDBCacheStore.class.getName());
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.testImmutability("location");
        this.setProperty(location, "location", (Properties)this.properties);
        this.location = location;
    }

    public int getExpiryQueueSize() {
        return this.expiryQueueSize;
    }

    public void setExpiryQueueSize(int expiryQueueSize) {
        this.testImmutability("expiryQueueSize");
        this.setProperty(String.valueOf(expiryQueueSize), "expiryQueueSize", (Properties)this.properties);
        this.expiryQueueSize = expiryQueueSize;
    }

    public String getExpiredLocation() {
        return this.expiredLocation;
    }

    public void setExpiredLocation(String expiredLocation) {
        this.testImmutability("expiredLocation");
        this.setProperty(expiredLocation, "expiredLocation", (Properties)this.properties);
        this.expiredLocation = expiredLocation;
    }

    public int getClearThreshold() {
        return this.clearThreshold;
    }

    public void setClearThreshold(int clearThreshhold) {
        this.testImmutability("clearThreshhold");
        this.setProperty(String.valueOf(clearThreshhold), "clearThreshold", (Properties)this.properties);
        this.clearThreshold = clearThreshhold;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(String compressionType) {
        this.testImmutability("compressionType");
        this.setProperty(compressionType, "compressionType", (Properties)this.properties);
        this.compressionType = compressionType;
    }

    public String getImplementationType() {
        return this.implementationType;
    }

    public void setImplementationType(String implementationType) {
        this.testImmutability("implementationType");
        this.setProperty(implementationType, "implementationType", (Properties)this.properties);
        this.implementationType = implementationType;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(Integer blockSize) {
        this.testImmutability("blockSize");
        this.setProperty(String.valueOf(blockSize), "blockSize", (Properties)this.properties);
        this.blockSize = blockSize;
    }

    public Long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Long cacheSize) {
        this.setProperty(String.valueOf(cacheSize), "cacheSize", (Properties)this.properties);
        this.cacheSize = cacheSize;
    }

    protected Options getDataDbOptions() {
        Options options = new Options().createIfMissing(true);
        options.compressionType(CompressionType.valueOf((String)this.compressionType));
        if (this.blockSize != null) {
            options.blockSize(this.blockSize.intValue());
        }
        if (this.cacheSize != null) {
            options.cacheSize(this.cacheSize.longValue());
        }
        return options;
    }

    protected Options getExpiredDbOptions() {
        return new Options().createIfMissing(true);
    }

    protected void setProperty(String properyValue, String propertyName, Properties p) {
        if (properyValue != null) {
            try {
                p.setProperty(propertyName, properyValue);
            }
            catch (UnsupportedOperationException e) {
                TypedProperties writableProperties = new TypedProperties(p);
                writableProperties.setProperty(propertyName, properyValue);
                this.setProperties((Properties)writableProperties);
            }
        }
    }

    public static enum ImplementationType {
        AUTO,
        JNI,
        JAVA;

    }
}

