/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.leveldb;

import java.io.File;
import java.util.concurrent.Executor;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.io.ByteBufferFactoryImpl;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.marshall.core.MarshalledEntryFactoryImpl;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.DummyInitializationContext;
import org.infinispan.persistence.leveldb.LevelDBStore;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfiguration;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfigurationBuilder;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.leveldb.LevelDBStoreTest")
public class LevelDBStoreTest
extends BaseStoreTest {
    private LevelDBStore fcs;
    private String tmpDirectory;
    private EmbeddedCacheManager cacheManager;

    @BeforeClass
    protected void setUpTempDir() {
        this.tmpDirectory = TestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove((String)this.tmpDirectory);
        new File(this.tmpDirectory).mkdirs();
    }

    protected LevelDBStoreConfiguration createCacheStoreConfig(PersistenceConfigurationBuilder lcb) {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((CacheMode)CacheMode.LOCAL, (boolean)false);
        LevelDBStoreConfigurationBuilder cfg = new LevelDBStoreConfigurationBuilder(lcb);
        cfg.location(this.tmpDirectory + "/data");
        cfg.expiredLocation(this.tmpDirectory + "/expiry");
        cfg.clearThreshold(2);
        return cfg.create();
    }

    protected StreamingMarshaller getMarshaller() {
        return this.cacheManager.getCache().getAdvancedCache().getComponentRegistry().getCacheMarshaller();
    }

    @AfterMethod
    public void tearDown() throws PersistenceException {
        super.tearDown();
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    protected AdvancedLoadWriteStore createStore() throws Exception {
        this.clearTempDir();
        this.fcs = new LevelDBStore();
        ConfigurationBuilder cb = new ConfigurationBuilder();
        LevelDBStoreConfiguration cfg = this.createCacheStoreConfig(cb.persistence());
        this.fcs.init((InitializationContext)new DummyInitializationContext((StoreConfiguration)cfg, this.getCache(), this.getMarshaller(), (ByteBufferFactory)new ByteBufferFactoryImpl(), (MarshalledEntryFactory)new MarshalledEntryFactoryImpl(this.getMarshaller())));
        this.fcs.start();
        return this.fcs;
    }

    public void testPurgeExpired() throws Exception {
        long lifespan = 1000L;
        InternalCacheEntry k1 = TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v1", (long)lifespan);
        InternalCacheEntry k2 = TestInternalCacheEntryFactory.create((Object)"k2", (Object)"v2", (long)lifespan);
        InternalCacheEntry k3 = TestInternalCacheEntryFactory.create((Object)"k3", (Object)"v3", (long)lifespan);
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)k1, (StreamingMarshaller)this.getMarshaller()));
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)k2, (StreamingMarshaller)this.getMarshaller()));
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)k3, (StreamingMarshaller)this.getMarshaller()));
        assert (this.cl.contains((Object)"k1"));
        assert (this.cl.contains((Object)"k2"));
        assert (this.cl.contains((Object)"k3"));
        Thread.sleep(lifespan + 100L);
        this.cl.purge((Executor)new WithinThreadExecutor(), null);
        LevelDBStore fcs = (LevelDBStore)this.cl;
        assert (fcs.load((Object)"k1") == null);
        assert (fcs.load((Object)"k2") == null);
        assert (fcs.load((Object)"k3") == null);
    }

    public void testStopStartDoesntNukeValues() throws InterruptedException {
        assert (!this.cl.contains((Object)"k1"));
        assert (!this.cl.contains((Object)"k2"));
        long lifespan = 1L;
        long idle = 1L;
        InternalCacheEntry se1 = TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v1", (long)lifespan);
        InternalCacheEntry se2 = TestInternalCacheEntryFactory.create((Object)"k2", (Object)"v2");
        InternalCacheEntry se3 = TestInternalCacheEntryFactory.create((Object)"k3", (Object)"v3", (long)-1L, (long)idle);
        InternalCacheEntry se4 = TestInternalCacheEntryFactory.create((Object)"k4", (Object)"v4", (long)lifespan, (long)idle);
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)se1, (StreamingMarshaller)this.getMarshaller()));
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)se2, (StreamingMarshaller)this.getMarshaller()));
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)se3, (StreamingMarshaller)this.getMarshaller()));
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)se4, (StreamingMarshaller)this.getMarshaller()));
        Thread.sleep(100L);
        this.cl.purge((Executor)new WithinThreadExecutor(), null);
        this.cl.stop();
        this.cl.start();
        assert (se1.isExpired());
        assert (this.cl.load((Object)"k1") == null);
        assert (!this.cl.contains((Object)"k1"));
        assert (this.cl.load((Object)"k2") != null);
        assert (this.cl.contains((Object)"k2"));
        assert (this.cl.load((Object)"k2").getValue().equals("v2"));
        assert (se3.isExpired());
        assert (this.cl.load((Object)"k3") == null);
        assert (!this.cl.contains((Object)"k3"));
        assert (se3.isExpired());
        assert (this.cl.load((Object)"k3") == null);
        assert (!this.cl.contains((Object)"k3"));
    }
}

