/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.leveldb.config;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfiguration;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.leveldb.configuration.ConfigurationTest")
public class ConfigurationTest
extends AbstractInfinispanTest {
    private String tmpDirectory;
    private String tmpDataDirectory;
    private String tmpExpiredDirectory;

    @BeforeTest
    protected void setUpTempDir() {
        this.tmpDirectory = TestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
        this.tmpDataDirectory = this.tmpDirectory + "/data";
        this.tmpExpiredDirectory = this.tmpDirectory + "/expired";
    }

    @AfterTest(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove((String)this.tmpDirectory);
    }

    public void testConfigBuilder() {
        GlobalConfiguration globalConfig = new GlobalConfigurationBuilder().globalJmxStatistics().transport().defaultTransport().build();
        Configuration cacheConfig = ((LevelDBStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(LevelDBStoreConfigurationBuilder.class)).location(this.tmpDataDirectory).expiredLocation(this.tmpExpiredDirectory).implementationType(LevelDBStoreConfiguration.ImplementationType.AUTO).build();
        StoreConfiguration cacheLoaderConfig = (StoreConfiguration)cacheConfig.persistence().stores().get(0);
        AssertJUnit.assertTrue((boolean)(cacheLoaderConfig instanceof LevelDBStoreConfiguration));
        LevelDBStoreConfiguration leveldbConfig = (LevelDBStoreConfiguration)cacheLoaderConfig;
        AssertJUnit.assertEquals((String)this.tmpDataDirectory, (String)leveldbConfig.location());
        AssertJUnit.assertEquals((String)this.tmpExpiredDirectory, (String)leveldbConfig.expiredLocation());
        DefaultCacheManager cacheManager = new DefaultCacheManager(globalConfig);
        cacheManager.defineConfiguration("testCache", cacheConfig);
        cacheManager.start();
        Cache cache = cacheManager.getCache("testCache");
        cache.put((Object)"hello", (Object)"there");
        cache.stop();
        cacheManager.stop();
    }

    @Test(enabled=false, description="ISPN-3388")
    public void testLegacyJavaConfig() {
        GlobalConfiguration globalConfig = new GlobalConfigurationBuilder().globalJmxStatistics().transport().defaultTransport().build();
        Configuration cacheConfig = ((LevelDBStoreConfigurationBuilder)((LevelDBStoreConfigurationBuilder)((LevelDBStoreConfigurationBuilder)((LevelDBStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(LevelDBStoreConfigurationBuilder.class)).addProperty("location", this.tmpDataDirectory)).addProperty("expiredLocation", this.tmpExpiredDirectory)).addProperty("implementationType", LevelDBStoreConfiguration.ImplementationType.AUTO.toString())).build();
        DefaultCacheManager cacheManager = new DefaultCacheManager(globalConfig);
        cacheManager.defineConfiguration("testCache", cacheConfig);
        cacheManager.start();
        Cache cache = cacheManager.getCache("testCache");
        cache.put((Object)"hello", (Object)"there legacy java");
        cache.stop();
        cacheManager.stop();
    }

    @Test(enabled=false, description="ISPN-3388")
    public void textXmlConfigLegacy() throws IOException {
        DefaultCacheManager cacheManager = new DefaultCacheManager("config/leveldb-config-legacy-" + LevelDBStoreConfiguration.ImplementationType.AUTO.toString().toLowerCase() + ".xml");
        Cache cache = cacheManager.getCache("testCache");
        cache.put((Object)"hello", (Object)"there legacy xml");
        cache.stop();
        cacheManager.stop();
        TestingUtil.recursiveFileRemove((String)"/tmp/leveldb/legacy");
    }

    public void testXmlConfig60() throws IOException {
        DefaultCacheManager cacheManager = new DefaultCacheManager("config/leveldb-config-60-" + LevelDBStoreConfiguration.ImplementationType.AUTO.toString().toLowerCase() + ".xml");
        Cache cache = cacheManager.getCache("testCache");
        cache.put((Object)"hello", (Object)"there 60 xml");
        cache.stop();
        cacheManager.stop();
        TestingUtil.recursiveFileRemove((String)"/tmp/leveldb/60");
    }
}

