/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.leveldb.config;

import java.io.IOException;
import java.io.InputStream;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfiguration;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.leveldb.configuration.ConfigurationTest")
public class ConfigurationTest
extends AbstractInfinispanTest {
    private String tmpDirectory = TestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
    private String tmpDataDirectory = this.tmpDirectory + "/data";
    private String tmpExpiredDirectory = this.tmpDirectory + "/expired";

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    public void testConfigBuilder() {
        GlobalConfiguration globalConfig = new GlobalConfigurationBuilder().globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true)).transport().defaultTransport().build();
        Configuration cacheConfig = ((LevelDBStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(LevelDBStoreConfigurationBuilder.class)).location(this.tmpDataDirectory).expiredLocation(this.tmpExpiredDirectory).implementationType(LevelDBStoreConfiguration.ImplementationType.AUTO).build();
        StoreConfiguration cacheLoaderConfig = (StoreConfiguration)cacheConfig.persistence().stores().get(0);
        AssertJUnit.assertTrue((boolean)(cacheLoaderConfig instanceof LevelDBStoreConfiguration));
        LevelDBStoreConfiguration leveldbConfig = (LevelDBStoreConfiguration)cacheLoaderConfig;
        AssertJUnit.assertEquals((String)this.tmpDataDirectory, (String)leveldbConfig.location());
        AssertJUnit.assertEquals((String)this.tmpExpiredDirectory, (String)leveldbConfig.expiredLocation());
        DefaultCacheManager cacheManager = new DefaultCacheManager(globalConfig);
        cacheManager.defineConfiguration("testCache", cacheConfig);
        cacheManager.start();
        Cache cache = cacheManager.getCache("testCache");
        cache.put((Object)"hello", (Object)"there");
        cache.stop();
        cacheManager.stop();
    }

    public void testXmlConfig() throws IOException {
        InputStream configSTream = ConfigurationTest.class.getResourceAsStream("/config/leveldb-config-auto.xml");
        ConfigurationBuilderHolder configHolder = new ParserRegistry().parse(configSTream);
        Configuration cacheConfig = ((ConfigurationBuilder)configHolder.getNamedConfigurationBuilders().get("testCache")).build();
        AssertJUnit.assertFalse((boolean)cacheConfig.persistence().passivation());
        AssertJUnit.assertEquals((int)cacheConfig.persistence().stores().size(), (int)1);
        StoreConfiguration cacheLoaderConfig = (StoreConfiguration)cacheConfig.persistence().stores().get(0);
        AssertJUnit.assertFalse((boolean)cacheLoaderConfig.shared());
        AssertJUnit.assertTrue((boolean)cacheLoaderConfig.preload());
        AssertJUnit.assertTrue((boolean)(cacheLoaderConfig instanceof LevelDBStoreConfiguration));
        LevelDBStoreConfiguration leveldbConfig = (LevelDBStoreConfiguration)cacheLoaderConfig;
        AssertJUnit.assertEquals((String)"/tmp/leveldb/52/data", (String)leveldbConfig.location());
        AssertJUnit.assertEquals((String)"/tmp/leveldb/52/expired", (String)leveldbConfig.expiredLocation());
        AssertJUnit.assertEquals((Object)LevelDBStoreConfiguration.ImplementationType.AUTO, (Object)leveldbConfig.implementationType());
    }
}

