/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.leveldb;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.persistence.leveldb.LevelDBStoreFunctionalTest;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfiguration;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.leveldb.JavaLevelDBStoreFunctionalTest")
public class JavaLevelDBStoreFunctionalTest
extends LevelDBStoreFunctionalTest {
    public static final int EXPIRATION_TIMEOUT = 3000;

    protected PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder loaders, boolean preload) {
        super.createStoreBuilder(loaders).implementationType(LevelDBStoreConfiguration.ImplementationType.JAVA).preload(preload);
        return loaders;
    }

    public void testEntrySetAfterExpiryWithStore() throws Exception {
        ConfigurationBuilder cb = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        this.createCacheStoreConfig(cb.persistence(), true);
        this.cacheManager.defineConfiguration("testEntrySetAfterExpiryWithStore", cb.build());
        Cache cache = this.cacheManager.getCache("testEntrySetAfterExpiryWithStore");
        cache.start();
        cache.clear();
        Assert.assertEquals((int)cache.entrySet().size(), (int)0);
        HashMap<Integer, Integer> dataIn = new HashMap<Integer, Integer>();
        dataIn.put(1, 1);
        dataIn.put(2, 2);
        cache.putAll(dataIn, 3000L, TimeUnit.MILLISECONDS);
        Thread.sleep(4000L);
        Assert.assertEquals((int)cache.entrySet().size(), (int)0);
    }
}

