/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.BaseStoreFunctionalTest;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RemoteStoreFunctionalTest", groups={"functional"})
public class RemoteStoreFunctionalTest
extends BaseStoreFunctionalTest {
    private EmbeddedCacheManager localCacheManager;
    private HotRodServer hrServer;

    protected PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder persistence, boolean preload) {
        this.localCacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.hrServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.localCacheManager);
        ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)persistence.addStore(RemoteStoreConfigurationBuilder.class)).remoteCacheName("").preload(preload)).addServer().host("localhost").port(this.hrServer.getPort().intValue());
        return persistence;
    }

    protected void teardown() {
        super.teardown();
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hrServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.localCacheManager});
    }

    public void testTwoCachesSameCacheStore() {
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testSegmentedWithUnsupportedVersion() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)cb.persistence().addStore(RemoteStoreConfigurationBuilder.class)).segmented(true)).protocolVersion(ProtocolVersion.PROTOCOL_VERSION_21);
        cb.build();
    }
}

