/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.persistence.remote.upgrade.TestCluster;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="upgrade.hotrod.HotRodUpgradeEncodings")
public class HotRodUpgradeEncodings
extends AbstractInfinispanTest {
    private static final String CACHE_NAME = "encoded";
    private TestCluster sourceCluster;
    private TestCluster targetCluster;
    private StorageType storageType;

    @Factory
    public Object[] factory() {
        return new Object[]{new HotRodUpgradeEncodings().withStorage(StorageType.BINARY), new HotRodUpgradeEncodings().withStorage(StorageType.OBJECT), new HotRodUpgradeEncodings().withStorage(StorageType.OFF_HEAP)};
    }

    protected String parameters() {
        return "[" + this.storageType.toString() + "]";
    }

    public HotRodUpgradeEncodings withStorage(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    @BeforeClass
    public void setup() {
        ConfigurationBuilder configurationBuilder = AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC);
        configurationBuilder.clustering().hash().numSegments(2);
        configurationBuilder.memory().storageType(this.storageType);
        this.sourceCluster = new TestCluster.Builder().setName("sourceCluster").setNumMembers(2).cache().name(CACHE_NAME).configuredWith(configurationBuilder).build();
        this.targetCluster = new TestCluster.Builder().setName("targetCluster").setNumMembers(2).cache().name(CACHE_NAME).remotePort(this.sourceCluster.getHotRodPort()).configuredWith(configurationBuilder).build();
    }

    @AfterClass
    public void tearDown() {
        this.targetCluster.destroy();
        this.sourceCluster.destroy();
    }

    void loadSourceCluster(int entries) {
        RemoteCache<String, String> remoteCache = this.sourceCluster.getRemoteCache(CACHE_NAME);
        ((Stream)IntStream.range(0, entries).boxed().parallel()).map(String::valueOf).forEach(k -> remoteCache.put(k, (Object)("value" + k)));
    }

    @Test
    public void testMigrate() throws Exception {
        int entries = 1000;
        this.loadSourceCluster(entries);
        RollingUpgradeManager rum = this.targetCluster.getRollingUpgradeManager(CACHE_NAME);
        rum.synchronizeData("hotrod", 10, 2);
        this.targetCluster.disconnectSource("hotrod");
        Assert.assertEquals((int)this.targetCluster.getRemoteCache(CACHE_NAME).size(), (int)entries);
    }
}

