/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.persistence.remote.upgrade.TestCluster;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="upgrade.hotrod.HotRodUpgradeStressTest", groups={"stress"})
public class HotRodUpgradeStressTest
extends AbstractInfinispanTest {
    private static final String CACHE_NAME = "stress";
    private TestCluster sourceCluster;
    private TestCluster targetCluster;

    @BeforeClass
    public void setup() throws Exception {
        this.sourceCluster = new TestCluster.Builder().setName("sourceCluster").setNumMembers(2).cache().name(CACHE_NAME).build();
        this.targetCluster = new TestCluster.Builder().setName("targetCluster").setNumMembers(2).cache().name(CACHE_NAME).remotePort(this.sourceCluster.getHotRodPort()).build();
    }

    @AfterClass
    public void tearDown() {
        this.targetCluster.destroy();
        this.sourceCluster.destroy();
    }

    void loadSourceCluster(int entries) {
        RemoteCache<String, String> remoteCache = this.sourceCluster.getRemoteCache(CACHE_NAME);
        AtomicInteger count = new AtomicInteger(0);
        ((Stream)IntStream.range(0, entries).boxed().parallel()).map(String::valueOf).forEach(k -> {
            remoteCache.put(k, (Object)("value" + k));
            int progress = count.incrementAndGet();
            if (progress % 10000 == 0) {
                System.out.printf("Loaded %d\n", progress);
            }
        });
    }

    @Test
    public void testMigrate() throws Exception {
        this.loadSourceCluster(1000000);
        long start = System.currentTimeMillis();
        RollingUpgradeManager rum = this.targetCluster.getRollingUpgradeManager(CACHE_NAME);
        rum.synchronizeData("hotrod", 1000, 5);
        System.out.println("Elapsed (s): " + (System.currentTimeMillis() - start) / 1000L);
        rum.disconnectSource("hotrod");
        Assert.assertEquals((int)this.targetCluster.getRemoteCache(CACHE_NAME).size(), (int)this.sourceCluster.getRemoteCache(CACHE_NAME).size());
    }
}

