/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote;

import junit.framework.Assert;
import org.infinispan.Cache;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.remote.RemoteCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(testName="loaders.remote.RemoteCacheStoreConfigTest", groups={"functional"})
public class RemoteCacheStoreConfigTest {
    public static final String CACHE_LOADER_CONFIG = "remote-cl-config.xml";
    private EmbeddedCacheManager cacheManager;
    private HotRodServer hotRodServer;

    @BeforeTest
    public void startUp() {
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager((boolean)false);
        Assert.assertEquals((int)this.cacheManager.getCache().size(), (int)0);
        this.hotRodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (int)19711);
    }

    public void simpleTest() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)CACHE_LOADER_CONFIG)){

            public void call() throws Exception {
                Cache cache = this.cm.getCache();
                CacheLoader cacheLoader = TestingUtil.getCacheLoader((Cache)cache);
                assert (cacheLoader != null);
                assert (cacheLoader instanceof RemoteCacheStore);
                cache.put((Object)"k", (Object)"v");
                Assert.assertEquals((int)1, (int)RemoteCacheStoreConfigTest.this.cacheManager.getCache().size());
                cache.stop();
                Assert.assertEquals((int)1, (int)RemoteCacheStoreConfigTest.this.cacheManager.getCache().size());
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)CACHE_LOADER_CONFIG)){

            public void call() throws Exception {
                Cache cache = this.cm.getCache();
                Assert.assertEquals((Object)"v", (Object)cache.get((Object)"k"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterTest(alwaysRun=true)
    public void tearDown() {
        try {
            if (this.hotRodServer != null) {
                this.hotRodServer.stop();
            }
        }
        finally {
            if (this.cacheManager != null) {
                this.cacheManager.stop();
            }
        }
    }
}

