/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote;

import java.util.Properties;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.remote.RemoteCacheStore;
import org.infinispan.loaders.remote.RemoteCacheStoreConfig;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="loaders.remote.RemoteCacheStoreTest", groups={"functional"})
public class RemoteCacheStoreTest
extends BaseCacheStoreTest {
    private EmbeddedCacheManager localCacheManager;
    private HotRodServer hrServer;

    protected CacheStore createCacheStore() throws Exception {
        RemoteCacheStoreConfig remoteCacheStoreConfig = new RemoteCacheStoreConfig();
        remoteCacheStoreConfig.setPurgeSynchronously(Boolean.valueOf(true));
        remoteCacheStoreConfig.setUseDefaultRemoteCache(true);
        assert (remoteCacheStoreConfig.isUseDefaultRemoteCache());
        this.localCacheManager = TestCacheManagerFactory.createLocalCacheManager((boolean)false);
        this.localCacheManager.getDefaultConfiguration().fluent().eviction().maxEntries(Integer.valueOf(100)).strategy(EvictionStrategy.UNORDERED).expiration().wakeUpInterval(Long.valueOf(10L)).build();
        this.hrServer = TestHelper.startHotRodServer((EmbeddedCacheManager)this.localCacheManager);
        Properties properties = new Properties();
        properties.put("infinispan.client.hotrod.server_list", "localhost:" + this.hrServer.getPort());
        remoteCacheStoreConfig.setHotRodClientProperties(properties);
        RemoteCacheStore remoteCacheStore = new RemoteCacheStore();
        remoteCacheStore.init((CacheLoaderConfig)remoteCacheStoreConfig, this.getCache(), this.getMarshaller());
        remoteCacheStore.start();
        return remoteCacheStore;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.hrServer.stop();
        this.localCacheManager.stop();
    }

    protected void assertEventuallyExpires(String key) throws Exception {
        for (int i = 0; i < 10 && this.cs.load((Object)"k") != null; ++i) {
            Thread.sleep(1000L);
        }
        assert (this.cs.load((Object)"k") == null);
    }

    protected void sleepForStopStartTest() throws InterruptedException {
        Thread.sleep(3000L);
    }

    protected void purgeExpired() throws CacheLoaderException {
        this.localCacheManager.getCache().getAdvancedCache().getEvictionManager().processEviction();
    }

    public void testLoadKeys() throws CacheLoaderException {
    }

    public void testReplaceExpiredEntry() throws Exception {
        this.cs.store(TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v1", (long)100L));
        TestingUtil.sleepThread((long)1100L);
        assert (null == this.cs.load((Object)"k1"));
        this.cs.store(TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v2", (long)100L));
        assert (this.cs.load((Object)"k1").getValue().equals("v2"));
    }
}

