/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote;

import io.reactivex.Flowable;
import java.io.IOException;
import java.util.function.ToIntBiFunction;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.reactivestreams.Publisher;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="persistence.remote.RemoteStoreTest", groups={"functional"})
public class RemoteStoreTest
extends BaseStoreTest {
    private static final String REMOTE_CACHE = "remote-cache";
    private EmbeddedCacheManager localCacheManager;
    private HotRodServer hrServer;

    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder localBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        localBuilder.memory().evictionType(EvictionType.COUNT).size(120L).expiration().wakeUpInterval(10L);
        localBuilder.clustering().cacheMode(CacheMode.DIST_SYNC);
        GlobalConfigurationBuilder globalConfig = new GlobalConfigurationBuilder().clusteredDefault();
        globalConfig.globalJmxStatistics().defaultCacheName(REMOTE_CACHE);
        this.localCacheManager = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalConfig, (ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)localBuilder));
        this.localCacheManager.getCache(REMOTE_CACHE);
        TestingUtil.replaceComponent((CacheContainer)this.localCacheManager, TimeService.class, (Object)this.timeService, (boolean)true);
        this.localCacheManager.getCache(REMOTE_CACHE).getAdvancedCache().getComponentRegistry().rewire();
        this.hrServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.localCacheManager);
        this.hrServer.setMarshaller((Marshaller)this.getMarshaller());
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        RemoteStoreConfigurationBuilder storeConfigurationBuilder = ((RemoteStoreConfigurationBuilder)builder.persistence().addStore(RemoteStoreConfigurationBuilder.class)).remoteCacheName(REMOTE_CACHE);
        storeConfigurationBuilder.addServer().host(this.hrServer.getHost()).port(this.hrServer.getPort().intValue());
        RemoteStore remoteStore = new RemoteStore();
        remoteStore.init(this.createContext(builder.build()));
        return remoteStore;
    }

    protected StreamingMarshaller getMarshaller() {
        return this.localCacheManager.getCache(REMOTE_CACHE).getAdvancedCache().getComponentRegistry().getCacheMarshaller();
    }

    @AfterMethod
    public void tearDown() {
        super.tearDown();
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hrServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.localCacheManager});
    }

    protected boolean storePurgesAllExpired() {
        return false;
    }

    public void testReplaceExpiredEntry() throws Exception {
        this.cl.write(this.marshalledEntry(this.internalCacheEntry("k1", "v1", 100L)));
        this.timeService.advance(1101L);
        AssertJUnit.assertNull((Object)this.cl.load((Object)"k1"));
        long start = System.currentTimeMillis();
        this.cl.write(this.marshalledEntry(this.internalCacheEntry("k1", "v2", 100L)));
        AssertJUnit.assertTrue((this.cl.load((Object)"k1").getValue().equals("v2") || TestingUtil.moreThanDurationElapsed((long)start, (long)100L) ? 1 : 0) != 0);
    }

    void countWithSegments(ToIntBiFunction<SegmentedAdvancedLoadWriteStore<?, ?>, IntSet> countFunction) {
        Cache cache = this.localCacheManager.getCache(REMOTE_CACHE);
        RemoteStore rs = (RemoteStore)this.cl;
        rs.write(this.marshalledEntry(this.internalCacheEntry("k1", "v1", 100L)));
        CloseableIterator iter = cache.keySet().iterator();
        AssertJUnit.assertTrue((boolean)iter.hasNext());
        byte[] key = (byte[])iter.next();
        AssertJUnit.assertFalse((boolean)iter.hasNext());
        KeyPartitioner keyPartitioner = (KeyPartitioner)TestingUtil.extractComponent((Cache)cache, KeyPartitioner.class);
        int segment = keyPartitioner.getSegment((Object)key);
        AssertJUnit.assertEquals((int)1, (int)countFunction.applyAsInt((SegmentedAdvancedLoadWriteStore<?, ?>)rs, IntSets.immutableSet((int)segment)));
        int maxSegments = cache.getCacheConfiguration().clustering().hash().numSegments();
        IntSet intSet = IntSets.mutableEmptySet((int)maxSegments);
        for (int i = 0; i < maxSegments; ++i) {
            if (i == segment) continue;
            intSet.set(i);
        }
        AssertJUnit.assertEquals((int)0, (int)countFunction.applyAsInt((SegmentedAdvancedLoadWriteStore<?, ?>)rs, intSet));
    }

    public void testPublishKeysWithSegments() throws IOException, InterruptedException {
        this.countWithSegments((salws, intSet) -> ((Long)Flowable.fromPublisher((Publisher)salws.publishKeys(intSet, null)).count().blockingGet()).intValue());
    }

    public void testPublishEntriesWithSegments() throws IOException, InterruptedException {
        this.countWithSegments((salws, intSet) -> ((Long)Flowable.fromPublisher((Publisher)salws.publishEntries(intSet, null, true, true)).count().blockingGet()).intValue());
    }
}

