/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheConfiguration;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.util.ExcludeListExcluder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CacheConfigurationTest {
    private static final String CACHE_NAME = "testCache";
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass());

    @Before
    public void startUp() {
        Caching.close();
    }

    @Test
    public void checkDefaults() {
        CacheConfiguration config = this.getCacheConfiguration("testCache0");
        Assert.assertFalse((boolean)config.isReadThrough());
        Assert.assertFalse((boolean)config.isWriteThrough());
        Assert.assertFalse((boolean)config.isStatisticsEnabled());
        for (CacheConfiguration.ExpiryType type : CacheConfiguration.ExpiryType.values()) {
            Assert.assertEquals((Object)CacheConfiguration.Duration.ETERNAL, (Object)config.getExpiry(type));
        }
        Assert.assertTrue((boolean)config.isStoreByValue());
    }

    @Test
    public void notSame() {
        CacheConfiguration config1 = this.getCacheConfiguration("testCache1");
        CacheConfiguration config2 = this.getCacheConfiguration("testCache2");
        Assert.assertNotSame((Object)config1, (Object)config2);
    }

    @Test
    public void equals() {
        CacheConfiguration config1 = this.getCacheConfiguration("testCache1");
        CacheConfiguration config2 = this.getCacheConfiguration("testCache2");
        Assert.assertEquals((Object)config1, (Object)config2);
    }

    @Test
    public void equalsNotEquals() {
        CacheConfiguration config1;
        config1.setStatisticsEnabled(!(config1 = this.getCacheConfiguration("testCache1")).isStatisticsEnabled());
        CacheConfiguration config2 = this.getCacheConfiguration("testCache2");
        Assert.assertFalse((boolean)config1.equals(config2));
    }

    @Test
    public void setStatisticsEnabled() {
        CacheConfiguration config;
        boolean flag = (config = this.getCacheConfiguration(CACHE_NAME)).isStatisticsEnabled();
        config.setStatisticsEnabled(!flag);
        Assert.assertEquals((Object)(!flag ? 1 : 0), (Object)config.isStatisticsEnabled());
    }

    @Test
    public void DurationEquals() {
        CacheConfiguration.Duration duration1 = new CacheConfiguration.Duration(TimeUnit.DAYS, 2L);
        CacheConfiguration.Duration duration2 = new CacheConfiguration.Duration(TimeUnit.DAYS, 2L);
        Assert.assertEquals((Object)duration1, (Object)duration2);
    }

    @Test
    public void durationNotEqualsAmount() {
        CacheConfiguration.Duration duration1 = new CacheConfiguration.Duration(TimeUnit.DAYS, 2L);
        CacheConfiguration.Duration duration2 = new CacheConfiguration.Duration(TimeUnit.DAYS, 3L);
        Assert.assertFalse((boolean)duration1.equals((Object)duration2));
        Assert.assertFalse((duration1.hashCode() == duration2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void durationNotEqualsUnit() {
        CacheConfiguration.Duration duration1 = new CacheConfiguration.Duration(TimeUnit.DAYS, 2L);
        CacheConfiguration.Duration duration2 = new CacheConfiguration.Duration(TimeUnit.MINUTES, 2L);
        Assert.assertFalse((boolean)duration1.equals((Object)duration2));
        Assert.assertFalse((duration1.hashCode() == duration2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void durationEqualsWhenSemanticallyEqualsButExpressedDifferentUnits() {
        CacheConfiguration.Duration duration1 = new CacheConfiguration.Duration(TimeUnit.SECONDS, 120L);
        CacheConfiguration.Duration duration2 = new CacheConfiguration.Duration(TimeUnit.MINUTES, 2L);
        Assert.assertEquals((Object)duration1, (Object)duration2);
        Assert.assertEquals((long)duration1.hashCode(), (long)duration2.hashCode());
    }

    @Test
    public void durationEqualsWhenSemanticallyEqualsButExpressedDifferentUnitsHashCode() {
        CacheConfiguration.Duration duration1 = new CacheConfiguration.Duration(TimeUnit.SECONDS, 120L);
        CacheConfiguration.Duration duration2 = new CacheConfiguration.Duration(TimeUnit.MINUTES, 2L);
        Assert.assertEquals((Object)duration1, (Object)duration2);
        Assert.assertEquals((long)duration1.hashCode(), (long)duration2.hashCode());
    }

    @Test
    public void durationNotEqualsUnitEquals() {
        long time = 2L;
        CacheConfiguration.Duration duration1 = new CacheConfiguration.Duration(TimeUnit.HOURS, 2L);
        time *= 60L;
        CacheConfiguration.Duration duration2 = new CacheConfiguration.Duration(TimeUnit.MINUTES, 120L);
        Assert.assertEquals((Object)duration1, (Object)duration2);
        duration2 = new CacheConfiguration.Duration(TimeUnit.SECONDS, time *= 60L);
        Assert.assertEquals((Object)duration1, (Object)duration2);
        duration2 = new CacheConfiguration.Duration(TimeUnit.MILLISECONDS, time *= 1000L);
        Assert.assertEquals((Object)duration1, (Object)duration2);
    }

    @Test
    public void DurationExceptions() {
        CacheConfiguration.Duration duration1;
        try {
            duration1 = new CacheConfiguration.Duration(null, 2L);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            duration1 = new CacheConfiguration.Duration(TimeUnit.MINUTES, 0L);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            duration1 = new CacheConfiguration.Duration(TimeUnit.MICROSECONDS, 10L);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            duration1 = new CacheConfiguration.Duration(TimeUnit.MILLISECONDS, -10L);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private CacheConfiguration getCacheConfiguration(String cacheName) {
        Cache cache = CacheConfigurationTest.getCacheManager().getCache(cacheName);
        if (cache == null) {
            cache = CacheConfigurationTest.getCacheManager().createCacheBuilder(cacheName).build();
        }
        return cache.getConfiguration();
    }

    private static CacheManager getCacheManager() {
        return Caching.getCacheManager();
    }
}

