/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheLoader;
import javax.cache.TestSupport;
import javax.cache.util.ExcludeListExcluder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CacheLoaderTest
extends TestSupport {
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass());
    protected static final long FUTURE_WAIT_MILLIS = 100L;

    @After
    public void cleanup() {
        for (Cache cache : this.getCacheManager().getCaches()) {
            this.getCacheManager().removeCache(cache.getName());
        }
    }

    @Test
    public void load_NullKey() {
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).build();
        MockCacheLoader cl = new MockCacheLoader();
        try {
            cache.load(null);
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void load_Found() {
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).build();
        MockCacheLoader cl = new MockCacheLoader();
        Integer key = 1;
        cache.put((Object)key, (Object)key);
        try {
            Assert.assertNull((Object)cache.load((Object)key));
        }
        catch (NullPointerException e) {
            Assert.fail((String)"should not have thrown an exception - if key in store should return null");
        }
    }

    @Test
    public void load_NoCacheLoader() {
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).build();
        Integer key = 1;
        try {
            Assert.assertNull((Object)cache.load((Object)key));
        }
        catch (NullPointerException e) {
            Assert.fail((String)"should not have thrown an exception - with no cache loader should return null");
        }
    }

    @Test
    public void load_NullValue() throws Exception {
        Object valueDefault = null;
        MockCacheLoader<Integer, Integer> clDefault = new MockCacheLoader<Integer, Integer>(){

            @Override
            public Cache.Entry<Integer, Integer> load(final Integer key) {
                return new Cache.Entry<Integer, Integer>(){

                    public Integer getKey() {
                        return key;
                    }

                    public Integer getValue() {
                        return null;
                    }
                };
            }
        };
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader((CacheLoader)clDefault).build();
        Integer key = 1;
        Future future = cache.load((Object)key);
        Assert.assertNotNull((Object)future);
        try {
            Assert.assertEquals(valueDefault, future.get(100L, TimeUnit.MILLISECONDS));
            Assert.fail((String)"should have thrown an exception - null value not allowed");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NullPointerException));
            Assert.assertFalse((boolean)cache.containsKey((Object)key));
        }
    }

    @Test
    public void load_DefaultCacheLoader() throws Exception {
        Integer valueDefault = 123;
        SimpleCacheLoader<Integer> clDefault = new SimpleCacheLoader<Integer>(valueDefault);
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        Future future = cache.load((Object)key);
        Assert.assertNotNull((Object)future);
        Assert.assertEquals((Object)valueDefault, future.get(100L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)cache.containsKey((Object)key));
        Assert.assertEquals((Object)valueDefault, (Object)cache.get((Object)key));
    }

    @Test
    public void load_ExceptionPropagation() throws Exception {
        RuntimeException expectedException = new RuntimeException("expected");
        SimpleCacheLoader clDefault = new SimpleCacheLoader(expectedException);
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        Future future = cache.load((Object)key);
        Assert.assertNotNull((Object)future);
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((Object)expectedException, (Object)e.getCause());
        }
    }

    @Test
    public void loadAll_NotStarted() {
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).build();
        cache.stop();
        try {
            cache.loadAll(null);
            Assert.fail((String)"should have thrown an exception - cache not started");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void loadAll_NullKeys() {
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).build();
        try {
            cache.loadAll(null);
            Assert.fail((String)"should have thrown an exception - keys null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void loadAll_NullKey() throws Exception {
        SimpleCacheLoader cl = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(cl).build();
        ArrayList<Object> keys = new ArrayList<Object>();
        keys.add(null);
        try {
            cache.loadAll(keys);
            Assert.fail((String)"should have thrown an exception - keys contains null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @Test
    public void loadAll_NullValue() throws Exception {
        MockCacheLoader<Integer, Integer> cl = new MockCacheLoader<Integer, Integer>(){

            @Override
            public Map<Integer, Integer> loadAll(Iterable<? extends Integer> keys) {
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                for (Integer n : keys) {
                    map.put(n, null);
                }
                return map;
            }
        };
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader((CacheLoader)cl).build();
        ArrayList<Integer> keys = new ArrayList<Integer>();
        keys.add(1);
        keys.add(2);
        Future future = cache.loadAll(keys);
        try {
            Map map = (Map)future.get(100L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)keys.size(), (long)map.size());
            Assert.fail((String)"should have thrown an exception - null value");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NullPointerException));
        }
    }

    @Test
    public void loadAll_1Found1Not() throws Exception {
        SimpleCacheLoader cl = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(cl).build();
        Integer keyThere = 1;
        cache.put((Object)keyThere, (Object)keyThere);
        Integer keyNotThere = keyThere + 1;
        ArrayList<Integer> keys = new ArrayList<Integer>();
        keys.add(keyThere);
        keys.add(keyNotThere);
        Future future = cache.loadAll(keys);
        Map map = (Map)future.get(100L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)keyNotThere, map.get(keyNotThere));
        Assert.assertEquals((Object)keyThere, (Object)cache.get((Object)keyThere));
        Assert.assertEquals((Object)keyNotThere, (Object)cache.get((Object)keyNotThere));
    }

    @Test
    public void loadAll_NoCacheLoader() throws Exception {
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).build();
        ArrayList<Integer> keys = new ArrayList<Integer>();
        keys.add(1);
        try {
            Assert.assertNull((Object)cache.loadAll(keys));
        }
        catch (NullPointerException e) {
            Assert.fail((String)"should not have thrown an exception - with no cache loader should return null");
        }
    }

    @Test
    public void loadAll_DefaultCacheLoader() throws Exception {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        keys.add(1);
        keys.add(2);
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Future future = cache.loadAll(keys);
        Map map = (Map)future.get(100L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)keys.size(), (long)map.size());
        for (Integer key : keys) {
            Assert.assertEquals((Object)key, map.get(key));
            Assert.assertEquals((Object)key, (Object)cache.get((Object)key));
        }
    }

    @Test
    public void loadAll_ExceptionPropagation() throws Exception {
        final RuntimeException expectedException = new RuntimeException("expected");
        MockCacheLoader<Integer, Integer> clDefault = new MockCacheLoader<Integer, Integer>(){

            @Override
            public Map<Integer, Integer> loadAll(Iterable<? extends Integer> keys) {
                throw expectedException;
            }
        };
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader((CacheLoader)clDefault).build();
        ArrayList<Integer> keys = new ArrayList<Integer>();
        keys.add(1);
        Future future = cache.loadAll(keys);
        Assert.assertNotNull((Object)future);
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((Object)expectedException, (Object)e.getCause());
        }
    }

    @Test
    public void get_Stored() {
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        Assert.assertFalse((boolean)cache.containsKey((Object)key));
        Assert.assertEquals((Object)key, (Object)cache.get((Object)key));
        Assert.assertTrue((boolean)cache.containsKey((Object)key));
        clDefault.exception = new NullPointerException();
        Assert.assertEquals((Object)key, (Object)cache.get((Object)key));
    }

    @Test
    public void get_Exception() {
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        clDefault.exception = new NullPointerException();
        try {
            cache.get((Object)key);
            Assert.fail((String)"should have got an exception ");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)clDefault.exception, (Object)e);
        }
    }

    @Test
    public void getAll() {
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        ArrayList<Integer> keysToGet = new ArrayList<Integer>();
        keysToGet.add(1);
        keysToGet.add(2);
        keysToGet.add(3);
        Map map = cache.getAll(keysToGet);
        Assert.assertEquals((long)keysToGet.size(), (long)map.size());
        for (Integer key : keysToGet) {
            Assert.assertTrue((boolean)map.containsKey(key));
            Assert.assertEquals((Object)cache.get((Object)key), map.get(key));
            Assert.assertEquals((Object)key, map.get(key));
        }
        for (Integer key : keysToGet) {
            Assert.assertTrue((boolean)cache.containsKey((Object)key));
        }
    }

    @Test
    public void containsKey() {
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        Assert.assertFalse((boolean)cache.containsKey((Object)key));
        Assert.assertEquals((Object)key, (Object)cache.get((Object)key));
        Assert.assertTrue((boolean)cache.containsKey((Object)key));
    }

    @Test
    public void putIfAbsent() {
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        Integer value = key + 1;
        Assert.assertTrue((boolean)cache.putIfAbsent((Object)key, (Object)value));
        Assert.assertEquals((Object)value, (Object)cache.get((Object)key));
    }

    @Test
    public void getAndRemove_NotExistent() {
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        Assert.assertNull((Object)cache.getAndRemove((Object)key));
        Assert.assertFalse((boolean)cache.containsKey((Object)key));
    }

    @Test
    public void getAndRemove_There() {
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        Integer value = key + 1;
        cache.put((Object)key, (Object)value);
        Assert.assertEquals((Object)value, (Object)cache.getAndRemove((Object)key));
        Assert.assertFalse((boolean)cache.containsKey((Object)key));
    }

    @Test
    public void replace_3arg_Missing() {
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        Integer newValue = key + 1;
        Assert.assertFalse((boolean)cache.replace((Object)key, (Object)key, (Object)newValue));
        Assert.assertFalse((boolean)cache.containsKey((Object)key));
    }

    @Test
    public void replace_3arg_Different() {
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        Integer value1 = key + 1;
        Integer value2 = value1 + 1;
        Integer value3 = value2 + 1;
        cache.put((Object)key, (Object)value1);
        Assert.assertFalse((boolean)cache.replace((Object)key, (Object)value2, (Object)value3));
        Assert.assertEquals((Object)value1, (Object)cache.get((Object)key));
    }

    @Test
    public void replace_3arg() {
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        Integer value1 = key + 1;
        Integer value2 = value1 + 1;
        Integer value3 = value2 + 1;
        cache.put((Object)key, (Object)value2);
        Assert.assertTrue((boolean)cache.replace((Object)key, (Object)value2, (Object)value3));
        Assert.assertEquals((Object)value3, (Object)cache.get((Object)key));
    }

    @Test
    public void replace_2arg_Missing() {
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        Assert.assertFalse((boolean)cache.replace((Object)key, (Object)key));
        Assert.assertFalse((boolean)cache.containsKey((Object)key));
    }

    @Test
    public void replace_2arg() {
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        Integer value1 = key + 1;
        Integer value2 = value1 + 1;
        Integer value3 = value2 + 1;
        cache.put((Object)key, (Object)value2);
        Assert.assertTrue((boolean)cache.replace((Object)key, (Object)value3));
        Assert.assertEquals((Object)value3, (Object)cache.get((Object)key));
    }

    @Test
    public void getAndReplace() {
        SimpleCacheLoader clDefault = new SimpleCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader(clDefault).build();
        Integer key = 1;
        Integer newValue = key + 1;
        Assert.assertNull((Object)cache.getAndReplace((Object)key, (Object)newValue));
        Assert.assertFalse((boolean)cache.containsKey((Object)key));
    }

    @Test
    public void get_WithNonKeyKey() {
        ArrayList<Integer> key1 = new ArrayList<Integer>();
        key1.add(1);
        key1.add(2);
        LinkedList key2 = new LinkedList(key1);
        ArrayListCacheLoader cacheLoader = new ArrayListCacheLoader();
        Cache cache = this.getCacheManager().createCacheBuilder(this.getTestCacheName()).setCacheLoader((CacheLoader)cacheLoader).build();
    }

    private static class ArrayListCacheLoader
    implements CacheLoader<ArrayList<Integer>, String> {
        private ArrayListCacheLoader() {
        }

        public Cache.Entry<ArrayList<Integer>, String> load(final ArrayList<Integer> key) {
            return new Cache.Entry<ArrayList<Integer>, String>(){

                public ArrayList<Integer> getKey() {
                    return new ArrayList<Integer>(key);
                }

                public String getValue() {
                    return key.toString();
                }
            };
        }

        public Map<ArrayList<Integer>, String> loadAll(Iterable<? extends ArrayList<Integer>> keys) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SimpleCacheLoader<K>
    implements CacheLoader<K, K> {
        private RuntimeException exception = null;
        private final K value;

        public SimpleCacheLoader() {
            this(null, null);
        }

        public SimpleCacheLoader(K value) {
            this(value, null);
        }

        public SimpleCacheLoader(RuntimeException exception) {
            this(null, exception);
        }

        public SimpleCacheLoader(K value, RuntimeException exception) {
            this.value = value;
            this.exception = exception;
        }

        public Cache.Entry<K, K> load(final Object key) {
            if (this.exception != null) {
                throw this.exception;
            }
            return new Cache.Entry<K, K>(){

                public K getKey() {
                    return key;
                }

                public K getValue() {
                    return SimpleCacheLoader.this.value == null ? key : SimpleCacheLoader.this.value;
                }
            };
        }

        public Map<K, K> loadAll(Iterable<? extends K> keys) {
            HashMap<K, K> map = new HashMap<K, K>();
            for (K key : keys) {
                map.put(key, key);
            }
            return map;
        }
    }

    protected static class MockCacheLoader<K, V>
    implements CacheLoader<K, V> {
        protected MockCacheLoader() {
        }

        public Cache.Entry<K, V> load(K key) {
            throw new UnsupportedOperationException();
        }

        public Map<K, V> loadAll(Iterable<? extends K> keys) {
            throw new UnsupportedOperationException();
        }
    }
}

