/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.CachingShutdownException;
import javax.cache.TestSupport;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;
import javax.cache.util.ExcludeListExcluder;
import javax.transaction.UserTransaction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CacheManagerNoTransactionsTest
extends TestSupport {
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass());

    @Before
    public void startUp() {
        try {
            Caching.close();
        }
        catch (CachingShutdownException cachingShutdownException) {
            // empty catch block
        }
    }

    @Test
    public void transactionalStatusWhenNoUserTransaction() throws Exception {
        CacheManager cacheManager = this.getCacheManager();
        try {
            UserTransaction userTrans = cacheManager.getUserTransaction();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void isolationLevelForNonTransactionalCache() throws Exception {
        CacheManager cacheManager = this.getCacheManager();
        Cache cache = cacheManager.createCacheBuilder("test").build();
        Assert.assertEquals((Object)IsolationLevel.NONE, (Object)cache.getConfiguration().getTransactionIsolationLevel());
    }

    @Test
    public void modeForNonTransactionalCache() throws Exception {
        CacheManager cacheManager = this.getCacheManager();
        Cache cache = cacheManager.createCacheBuilder("test").build();
        Assert.assertEquals((Object)Mode.NONE, (Object)cache.getConfiguration().getTransactionMode());
    }
}

