/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.CachingShutdownException;
import javax.cache.OptionalFeature;
import javax.cache.Status;
import javax.cache.TestSupport;
import javax.cache.util.ExcludeListExcluder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CacheManagerTest
extends TestSupport {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass()){

        @Override
        protected boolean isExcluded(String methodName) {
            if ("testUnwrap".equals(methodName) && CacheManagerTest.this.getUnwrapClass(CacheManager.class) == null) {
                return true;
            }
            return super.isExcluded(methodName);
        }
    };

    @Before
    public void startUp() {
        try {
            Caching.close();
        }
        catch (CachingShutdownException cachingShutdownException) {
            // empty catch block
        }
    }

    @Test
    public void createCacheBuilder_NullCacheName() {
        CacheManager cacheManager = this.getCacheManager();
        try {
            cacheManager.createCacheBuilder(null);
            Assert.fail((String)"should have thrown an exception - null cache name not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void createCache_Same() {
        String name = "c1";
        CacheManager cacheManager = this.getCacheManager();
        Cache cache = cacheManager.createCacheBuilder(name).build();
        Assert.assertSame((Object)cache, (Object)cacheManager.getCache(name));
    }

    @Test
    public void createCache_NameOK() {
        String name = "c1";
        Cache cache = this.getCacheManager().createCacheBuilder(name).build();
        Assert.assertEquals((Object)name, (Object)cache.getName());
    }

    @Test
    public void createCache_StatusOK() {
        String name = "c1";
        Cache cache = this.getCacheManager().createCacheBuilder(name).build();
        Assert.assertSame((Object)Status.STARTED, (Object)cache.getStatus());
    }

    @Test
    public void createCache_Different() {
        String name1 = "c1";
        CacheManager cacheManager = this.getCacheManager();
        Cache cache1 = cacheManager.createCacheBuilder(name1).build();
        Assert.assertEquals((Object)Status.STARTED, (Object)cache1.getStatus());
        String name2 = "c2";
        Cache cache2 = cacheManager.createCacheBuilder(name2).build();
        Assert.assertEquals((Object)Status.STARTED, (Object)cache2.getStatus());
        Assert.assertEquals((Object)cache1, (Object)cacheManager.getCache(name1));
        Assert.assertEquals((Object)cache2, (Object)cacheManager.getCache(name2));
    }

    @Test
    public void createCache_DifferentSameName() {
        CacheManager cacheManager = this.getCacheManager();
        String name1 = "c1";
        Cache cache1 = cacheManager.createCacheBuilder(name1).build();
        Assert.assertEquals((Object)cache1, (Object)cacheManager.getCache(name1));
        this.checkStarted(cache1);
        try {
            Cache cache2 = cacheManager.createCacheBuilder(name1).build();
        }
        catch (CacheException e) {
            // empty catch block
        }
    }

    @Test
    public void removeCache_Null() {
        CacheManager cacheManager = this.getCacheManager();
        try {
            cacheManager.removeCache(null);
            Assert.fail((String)"should have thrown an exception - cache name null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void removeCache_There() {
        CacheManager cacheManager = this.getCacheManager();
        String name1 = "c1";
        cacheManager.createCacheBuilder(name1).build();
        Assert.assertTrue((boolean)cacheManager.removeCache(name1));
        Assert.assertFalse((boolean)cacheManager.getCaches().iterator().hasNext());
    }

    @Test
    public void removeCache_CacheStopped() {
        CacheManager cacheManager = this.getCacheManager();
        String name1 = "c1";
        Cache cache1 = cacheManager.createCacheBuilder(name1).build();
        cacheManager.removeCache(name1);
        this.checkStopped(cache1);
    }

    @Test
    public void removeCache_NotThere() {
        CacheManager cacheManager = this.getCacheManager();
        Assert.assertFalse((boolean)cacheManager.removeCache("c1"));
    }

    @Test
    public void removeCache_Stopped() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.shutdown();
        try {
            cacheManager.removeCache("c1");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shutdown_stopCalled() {
        CacheManager cacheManager = this.getCacheManager();
        Cache cache1 = cacheManager.createCacheBuilder("c1").build();
        Cache cache2 = cacheManager.createCacheBuilder("c2").build();
        cacheManager.shutdown();
        this.checkStopped(cache1);
        this.checkStopped(cache2);
    }

    @Test
    public void shutdown_status() {
        CacheManager cacheManager = this.getCacheManager();
        Assert.assertEquals((Object)Status.STARTED, (Object)cacheManager.getStatus());
        cacheManager.shutdown();
        Assert.assertEquals((Object)Status.STOPPED, (Object)cacheManager.getStatus());
    }

    @Test
    public void shutdown_statusTwice() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.shutdown();
        try {
            cacheManager.shutdown();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shutdown_cachesEmpty() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.createCacheBuilder("c1").build();
        cacheManager.createCacheBuilder("c2").build();
        cacheManager.shutdown();
        Assert.assertFalse((boolean)cacheManager.getCaches().iterator().hasNext());
    }

    @Test
    public void getUserTransaction() {
        boolean transactions = Caching.isSupported((OptionalFeature)OptionalFeature.TRANSACTIONS);
        try {
            this.getCacheManager().getUserTransaction();
            if (!transactions) {
                Assert.fail();
            }
        }
        catch (UnsupportedOperationException e) {
            Assert.assertFalse((boolean)transactions);
        }
    }

    @Test
    public void getCache_Missing() {
        CacheManager cacheManager = this.getCacheManager();
        Assert.assertNull((Object)cacheManager.getCache("notThere"));
    }

    @Test
    public void getCache_There() {
        String name = this.toString();
        CacheManager cacheManager = this.getCacheManager();
        Cache cache = cacheManager.createCacheBuilder(name).build();
        Assert.assertSame((Object)cache, (Object)cacheManager.getCache(name));
    }

    @Test
    public void getCache_Missing_Stopped() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.shutdown();
        try {
            cacheManager.getCache("notThere");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getCache_There_Stopped() {
        String name = this.toString();
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.createCacheBuilder(name).build();
        cacheManager.shutdown();
        try {
            cacheManager.getCache(name);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getCaches_Empty() {
        CacheManager cacheManager = this.getCacheManager();
        Assert.assertFalse((boolean)cacheManager.getCaches().iterator().hasNext());
    }

    @Test
    public void getCaches_NotEmpty() {
        CacheManager cacheManager = this.getCacheManager();
        ArrayList<Cache> caches1 = new ArrayList<Cache>();
        caches1.add(cacheManager.createCacheBuilder("c1").build());
        caches1.add(cacheManager.createCacheBuilder("c2").build());
        caches1.add(cacheManager.createCacheBuilder("c3").build());
        this.checkCollections(caches1, cacheManager.getCaches());
    }

    @Test
    public void getCaches_MutateReturn() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.createCacheBuilder("c1").build();
        try {
            cacheManager.getCaches().iterator().remove();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void getCaches_MutateCacheManager() {
        CacheManager cacheManager = this.getCacheManager();
        String removeName = "c2";
        ArrayList<Cache> caches1 = new ArrayList<Cache>();
        caches1.add(cacheManager.createCacheBuilder("c1").build());
        cacheManager.createCacheBuilder(removeName).build();
        caches1.add(cacheManager.createCacheBuilder("c3").build());
        Iterable it = cacheManager.getCaches();
        int size = 0;
        for (Cache c : it) {
            ++size;
        }
        Assert.assertEquals((long)3L, (long)size);
        cacheManager.removeCache(removeName);
        size = 0;
        for (Cache c : it) {
            ++size;
        }
        Assert.assertEquals((long)3L, (long)size);
        it = cacheManager.getCaches();
        size = 0;
        for (Cache c : it) {
            ++size;
        }
        Assert.assertEquals((long)2L, (long)size);
        this.checkCollections(caches1, it);
    }

    @Test
    public void isSupported() {
        CacheManager cacheManager = this.getCacheManager();
        for (OptionalFeature feature : OptionalFeature.values()) {
            Assert.assertSame((String)feature.toString(), (Object)Caching.isSupported((OptionalFeature)feature), (Object)cacheManager.isSupported(feature));
        }
    }

    @Test
    public void addImmutableClass_Null() {
        CacheManager cacheManager = this.getCacheManager();
        try {
            cacheManager.registerImmutableClass(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void addImmutableClass_NotImmutable() {
        CacheManager cacheManager = this.getCacheManager();
        cacheManager.registerImmutableClass(Date.class);
    }

    @Test
    public void testUnwrap() {
        Class<?> unwrapClass = this.getUnwrapClass(CacheManager.class);
        CacheManager cacheManager = this.getCacheManager();
        Object unwrappedCacheManager = cacheManager.unwrap(unwrapClass);
        Assert.assertTrue((boolean)unwrapClass.isAssignableFrom(unwrappedCacheManager.getClass()));
    }

    private <T> void checkCollections(Collection<T> collection1, Iterable<?> iterable2) {
        ArrayList collection2 = new ArrayList();
        for (Object element : iterable2) {
            Assert.assertTrue((boolean)collection1.contains(element));
            collection2.add(element);
        }
        Assert.assertEquals((long)collection1.size(), (long)collection2.size());
        for (Object element : collection1) {
            Assert.assertTrue((boolean)collection2.contains(element));
        }
    }

    private void checkStarted(Cache cache) {
        Status status = cache.getStatus();
        Assert.assertTrue((status == Status.STARTED ? 1 : 0) != 0);
    }

    private void checkStopped(Cache cache) {
        Status status = cache.getStatus();
        Assert.assertTrue((status == Status.STOPPED ? 1 : 0) != 0);
    }
}

