/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.OptionalFeature;
import javax.cache.TestSupport;
import javax.cache.transaction.IsolationLevel;
import javax.cache.util.AllTestExcluder;
import javax.cache.util.ExcludeListExcluder;
import javax.transaction.UserTransaction;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class CacheManagerTransactionsTest
extends TestSupport {
    @Rule
    public MethodRule rule = Caching.isSupported((OptionalFeature)OptionalFeature.TRANSACTIONS) ? new ExcludeListExcluder(this.getClass()) : new AllTestExcluder();

    @Test
    public void transactionalStatusWhenNoUserTransaction() throws Exception {
        CacheManager cacheManager = this.getCacheManager();
        UserTransaction userTrans = cacheManager.getUserTransaction();
        Assert.assertEquals((long)6L, (long)userTrans.getStatus());
    }

    @Test
    public void isolationLevelForNonTransactionalCache() throws Exception {
        CacheManager cacheManager = this.getCacheManager();
        Cache cache = cacheManager.createCacheBuilder("test").build();
        Assert.assertEquals((Object)IsolationLevel.NONE, (Object)cache.getConfiguration().getTransactionIsolationLevel());
    }
}

