/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import domain.Beagle;
import domain.Identifier;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.cache.Cache;
import javax.cache.CacheConfiguration;
import javax.cache.CacheManager;
import javax.cache.CacheTestSupport;
import javax.cache.Caching;
import javax.cache.Status;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryReadListener;
import javax.cache.event.NotificationScope;
import javax.cache.util.ExcludeListExcluder;
import manager.CacheNameOnEachMethodBlogManagerImpl;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class CacheTest
extends CacheTestSupport<Long, String> {
    @Rule
    public MethodRule rule = new ExcludeListExcluder(this.getClass()){

        @Override
        protected boolean isExcluded(String methodName) {
            if ("testUnwrap".equals(methodName) && CacheTest.this.getUnwrapClass(CacheManager.class) == null) {
                return true;
            }
            return super.isExcluded(methodName);
        }
    };

    @Test
    public void simpleAPI() {
        String cacheName = "sampleCache";
        CacheManager cacheManager = this.getCacheManager();
        Cache cache = cacheManager.getCache(cacheName);
        cache = cacheManager.createCacheBuilder(cacheName).setStoreByValue(false).build();
        String key = "key";
        Integer value1 = 1;
        cache.put((Object)key, (Object)value1);
        Integer value2 = (Integer)cache.get((Object)key);
        Assert.assertEquals((Object)value1, (Object)value2);
    }

    @Test
    public void genericsTest() {
        String cacheName = "genericsCache";
        CacheManager cacheManager = this.getCacheManager();
        Cache cacheGeneric = cacheManager.getCache(cacheName);
        cacheGeneric = cacheManager.createCacheBuilder(cacheName).setStoreByValue(false).build();
        Beagle pistachio = new Beagle();
        cacheGeneric.put((Object)new Identifier("Pistachio"), (Object)pistachio);
        Cache cacheNonGeneric = cacheManager.getCache(cacheName);
    }

    @Test
    public void hashcode() {
        Identifier identifier = new Identifier("Pistachio");
        System.out.println(identifier.hashCode());
        System.out.println("Pistachio".hashCode());
    }

    @Test
    public void getCacheName() {
        Assert.assertEquals((Object)this.getTestCacheName(), (Object)this.cache.getName());
    }

    @Test
    public void containsKey_NotStarted() {
        this.cache.stop();
        try {
            this.cache.containsKey(null);
            Assert.fail((String)"should have thrown an exception - cache not started");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void containsKey_Null() {
        try {
            Assert.assertFalse((boolean)this.cache.containsKey(null));
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void containsKey() {
        LinkedHashMap<Long, String> data = this.createLSData(3);
        for (Map.Entry entry : data.entrySet()) {
            Assert.assertFalse((String)"before put", (boolean)this.cache.containsKey(entry.getKey()));
            this.cache.put(entry.getKey(), entry.getValue());
            Assert.assertTrue((String)"after put", (boolean)this.cache.containsKey(entry.getKey()));
        }
        for (Long key : data.keySet()) {
            Assert.assertTrue((String)"finally", (boolean)this.cache.containsKey((Object)key));
        }
    }

    @Test
    public void load_NotStarted() {
        this.cache.stop();
        try {
            this.cache.load(null);
            Assert.fail((String)"should have thrown an exception - cache not started");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getStatistics() {
        Assert.assertNull((Object)this.cache.getStatistics());
    }

    @Test
    public void getStatistics_NotEnabled() {
        this.cache.getConfiguration().setStatisticsEnabled(false);
        Assert.assertNull((Object)this.cache.getStatistics());
    }

    @Test
    public void getStatistics_Enabled() {
        this.cache.getConfiguration().setStatisticsEnabled(true);
        Assert.assertNotNull((Object)this.cache.getStatistics());
    }

    @Test
    public void registerCacheEntryListener() {
        MyCacheEntryListener listener = new MyCacheEntryListener();
        this.cache.registerCacheEntryListener(listener, NotificationScope.LOCAL, false);
    }

    @Test
    public void unregisterCacheEntryListener() {
        MyCacheEntryListener listener = new MyCacheEntryListener();
        this.cache.registerCacheEntryListener(listener, NotificationScope.LOCAL, false);
        this.cache.unregisterCacheEntryListener(null);
        this.cache.unregisterCacheEntryListener(listener);
    }

    @Test
    public void getConfiguration_Mutation() {
        CacheConfiguration config = this.cache.getConfiguration();
        boolean enabled = config.isStatisticsEnabled();
        Assert.assertEquals((Object)enabled, (Object)config.isStatisticsEnabled());
        config.setStatisticsEnabled(!enabled);
        Assert.assertEquals((Object)(!enabled ? 1 : 0), (Object)config.isStatisticsEnabled());
        Assert.assertEquals((Object)(!enabled ? 1 : 0), (Object)this.cache.getConfiguration().isStatisticsEnabled());
    }

    @Test
    public void iterator_NotStarted() {
        this.cache.stop();
        try {
            this.cache.iterator();
            Assert.fail((String)"should have thrown an exception - cache not started");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void iterator_Empty() {
        Iterator iterator = this.cache.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.remove();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            iterator.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void iterator() {
        LinkedHashMap<Long, String> data = this.createLSData(3);
        this.cache.putAll(data);
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            Cache.Entry next = (Cache.Entry)iterator.next();
            Assert.assertEquals((Object)next.getValue(), (Object)data.get(next.getKey()));
            iterator.remove();
            data.remove(next.getKey());
        }
        Assert.assertTrue((boolean)data.isEmpty());
    }

    @Test
    public void initialise() {
        Assert.assertEquals((Object)Status.STARTED, (Object)this.cache.getStatus());
    }

    @Test
    public void stop() {
        this.cache.stop();
        Assert.assertEquals((Object)Status.STOPPED, (Object)this.cache.getStatus());
    }

    @Test
    public void testUnwrap() {
        Class<?> unwrapClass = this.getUnwrapClass(Cache.class);
        Object unwrappedCache = this.cache.unwrap(unwrapClass);
        Assert.assertTrue((boolean)unwrapClass.isAssignableFrom(unwrappedCache.getClass()));
    }

    @Test
    public void testGetCacheManager() {
        String cacheName = "sampleCache";
        ClassLoader cl1 = Thread.currentThread().getContextClassLoader();
        URLClassLoader cl2 = URLClassLoader.newInstance(new URL[0], cl1);
        CacheManager cacheManager1 = Caching.getCacheManager((ClassLoader)cl1);
        CacheManager cacheManager2 = Caching.getCacheManager((ClassLoader)cl2);
        Assert.assertNotSame((Object)cacheManager1, (Object)cacheManager2);
        Cache cache1 = cacheManager1.createCacheBuilder(cacheName).build();
        Cache cache2 = cacheManager2.createCacheBuilder(cacheName).build();
        Assert.assertSame((Object)cacheManager1, (Object)cache1.getCacheManager());
        Assert.assertSame((Object)cacheManager2, (Object)cache2.getCacheManager());
    }

    @Test
    public void testAnnotations() {
        CacheNameOnEachMethodBlogManagerImpl value = new CacheNameOnEachMethodBlogManagerImpl();
        boolean foundRemoveAllAnnotation = false;
        for (Method m : value.getClass().getMethods()) {
            if (!m.isAnnotationPresent(CacheRemoveAll.class)) continue;
            System.out.println(m.getName());
            foundRemoveAllAnnotation = true;
        }
        Assert.assertTrue((boolean)foundRemoveAllAnnotation);
    }

    static class MyCacheEntryListener<K, V>
    implements CacheEntryReadListener<K, V> {
        MyCacheEntryListener() {
        }

        public void entryRead(CacheEntryEvent<? extends K, ? extends V> event) {
        }

        public void entriesRead(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) {
        }
    }
}

