/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.statistics;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.CacheStatistics;
import javax.cache.Status;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class MBeanServerRegistrationUtility {
    private static final Logger LOG = Logger.getLogger(MBeanServerRegistrationUtility.class.getName());
    private MBeanServer mBeanServer;
    private CacheManager cacheManager;
    private Status status;

    public MBeanServerRegistrationUtility(CacheManager cacheManager, MBeanServer mBeanServer) {
        this.cacheManager = cacheManager;
        this.mBeanServer = mBeanServer;
        this.status = Status.UNINITIALISED;
        try {
            for (Cache cache : this.cacheManager.getCaches()) {
                this.registerCacheStatistics(cache);
            }
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        this.status = Status.STARTED;
    }

    private ObjectName calculateObjectName(String cacheManagerName, String cacheName) {
        try {
            return new ObjectName("javax.cache:type=RICacheStatistics,CacheManager=" + cacheManagerName + ",name=" + MBeanServerRegistrationUtility.mbeanSafe(cacheName));
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static String mbeanSafe(String string) {
        return string == null ? "" : string.replaceAll(":|=|\n", ".");
    }

    private void registerCacheStatistics(Cache cache) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        CacheStatistics cacheStatistics = cache.getStatistics();
        if (cacheStatistics != null) {
            this.mBeanServer.registerMBean(cacheStatistics, this.calculateObjectName(this.cacheManager.getName(), cacheStatistics.getName()));
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void dispose() {
        Set<ObjectName> registeredObjectNames = null;
        try {
            registeredObjectNames = this.mBeanServer.queryNames(new ObjectName("javax.cache:*,CacheManager=" + this.cacheManager.getName()), null);
        }
        catch (MalformedObjectNameException e) {
            LOG.log(Level.SEVERE, "Error querying MBeanServer. Error was " + e.getMessage(), e);
        }
        for (ObjectName registeredObjectName : registeredObjectNames) {
            try {
                this.mBeanServer.unregisterMBean(registeredObjectName);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error unregistering object instance " + registeredObjectName + " . Error was " + e.getMessage(), e);
            }
        }
        this.status = Status.STOPPED;
    }
}

