/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum ExcludeList {
    INSTANCE(System.getProperty("ExcludeList", "ExcludeList"));

    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private final HashMap<String, Set<String>> map = new HashMap();

    private ExcludeList(String fileName) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
        if (url != null) {
            this.logger.info("===== ExcludeList url=" + url);
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                    this.handleLine(line);
                }
                in.close();
            }
            catch (IOException e) {
                this.logger.config(e.toString());
                this.logger.log(Level.SEVERE, "ExcludeList file:" + fileName, e);
            }
        }
    }

    private void handleLine(String line) {
        int dot = line.lastIndexOf("#");
        if (dot > 0) {
            String className = line.substring(0, dot);
            String methodName = line.substring(dot + 1);
            Set<String> entry = this.map.get(className);
            if (entry == null) {
                entry = new HashSet<String>();
                this.map.put(className, entry);
            }
            entry.add(methodName);
        } else {
            this.logger.log(Level.WARNING, "===== ExcludeList bad entry: " + line);
        }
    }

    private String getFileName() {
        return System.getProperty("ExcludeList", "ExcludeList");
    }

    public Set<String> getExcludes(String className) {
        return this.map.get(className);
    }
}

