/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.logging;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not find '%s' file in classpath, using defaults.", id=4001)
    public void couldNotFindPropertiesFile(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Cannot perform operations on a cache associated with an unstarted RemoteCacheManager. Use RemoteCacheManager.start before using the remote cache.", id=4002)
    public void unstartedRemoteCacheManager();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Invalid magic number. Expected %#x and received %#x", id=4003)
    public void invalidMagicNumber(short var1, short var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Invalid message id. Expected %d and received %d", id=4004)
    public void invalidMessageId(long var1, long var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error received from the server: %s", id=4005)
    public void errorFromServer(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="New topology: %s", id=4006)
    public void newTopology(Set<SocketAddress> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception encountered. Retry %d out of %d", id=4007)
    public void exceptionAndNoRetriesLeft(int var1, int var2, @Cause HotRodClientException var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not connect to server: %s", id=4008)
    public void couldNotConnectToServer(InetSocketAddress var1, @Cause IOException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Issues closing socket for %s: %s", id=4009)
    public void errorClosingSocket(TcpTransport var1, IOException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception while shutting down the connection pool.", id=4010)
    public void errorClosingConnectionPool(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No hash function configured for version: %d", id=4011)
    public void noHasHFunctionConfigured(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not invalidate connection: %s", id=4012)
    public void couldNoInvalidateConnection(TcpTransport var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not release connection: %s", id=4013)
    public void couldNotReleaseConnection(TcpTransport var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="New server added(%s), adding to the pool.", id=4014)
    public void newServerAdded(SocketAddress var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed adding new server %s", id=4015)
    public void failedAddingNewServer(SocketAddress var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Server not in cluster anymore(%s), removing from the pool.", id=4016)
    public void removingServer(SocketAddress var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not fetch transport", id=4017)
    public void couldNotFetchTransport(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to an int! Using default value of %d", id=4018)
    public void unableToConvertStringPropertyToInt(String var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to a long! Using default value of %d", id=4019)
    public void unableToConvertStringPropertyToLong(String var1, long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to a boolean! Using default value of %b", id=4020)
    public void unableToConvertStringPropertyToBoolean(String var1, boolean var2);
}

