/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.exceptions.RemoteCacheManagerNotStartedException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.CacheManagerNotStartedTest", groups={"functional"})
public class CacheManagerNotStartedTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "someName";
    EmbeddedCacheManager cacheManager = null;
    HotRodServer hotrodServer = null;
    RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager((boolean)false);
        this.cacheManager.defineConfiguration(CACHE_NAME, new Configuration());
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        this.remoteCacheManager = new RemoteCacheManager("localhost:" + this.hotrodServer.getHost(), false);
        return this.cacheManager;
    }

    @AfterTest(alwaysRun=true)
    public void release() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
        HotRodClientTestingUtil.killServers(this.hotrodServer);
    }

    @AfterClass(alwaysRun=true)
    protected void destroyAfterClass() {
        super.destroyAfterClass();
        try {
            this.remoteCacheManager.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testGetCacheOperations() {
        assert (this.remoteCacheManager.getCache() != null);
        assert (this.remoteCacheManager.getCache(CACHE_NAME) != null);
        assert (!this.remoteCacheManager.isStarted());
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testGetCacheOperations2() {
        this.remoteCacheManager.getCache().put((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testGetCacheOperations3() {
        this.remoteCacheManager.getCache(CACHE_NAME).put((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testPut() {
        this.cache().put((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testPutAsync() {
        this.cache().putAsync((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testGet() {
        this.cache().get((Object)"k");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testReplace() {
        this.cache().replace((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testReplaceAsync() {
        this.cache().replaceAsync((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testPutAll() {
        this.cache().putAll(new HashMap());
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testPutAllAsync() {
        this.cache().putAllAsync(new HashMap());
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testVersionedGet() {
        this.cache().getVersioned((Object)"key");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testVersionedRemove() {
        this.cache().removeWithVersion((Object)"key", 12312321L);
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testVersionedRemoveAsync() {
        this.cache().removeWithVersionAsync((Object)"key", 12312321L);
    }

    private RemoteCache<Object, Object> cache() {
        return this.remoteCacheManager.getCache();
    }
}

