/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ForceReturnValuesTest", groups={"functional"})
@CleanupAfterMethod
public class ForceReturnValuesTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager((boolean)false);
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = TestHelper.startHotRodServer(this.cacheManager);
        Properties hotrodClientConf = new Properties();
        hotrodClientConf.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer.getPort());
        this.remoteCacheManager = new RemoteCacheManager(hotrodClientConf);
        return this.cacheManager;
    }

    @AfterMethod(alwaysRun=true)
    void shutdown() {
        this.remoteCacheManager.stop();
        this.remoteCacheManager = null;
    }

    public void testDontForceReturnValues() {
        RemoteCache rc = this.remoteCacheManager.getCache();
        String rv = (String)rc.put((Object)"Key", (Object)"Value");
        assert (rv == null);
        rv = (String)rc.put((Object)"Key", (Object)"Value2");
        assert (rv == null);
    }

    public void testForceReturnValues() {
        RemoteCache rc = this.remoteCacheManager.getCache(true);
        String rv = (String)rc.put((Object)"Key", (Object)"Value");
        assert (rv == null);
        rv = (String)rc.put((Object)"Key", (Object)"Value2");
        assert (rv != null);
        assert ("Value".equals(rv));
    }
}

