/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.config.Configuration;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.PingOnStartupTest")
public class PingOnStartupTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        Configuration config = PingOnStartupTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.DIST_SYNC);
        this.createHotRodServers(2, config);
    }

    public void testTopologyFetched() throws Exception {
        Properties props = new Properties();
        HotRodServer hotRodServer2 = this.server(1);
        props.put("infinispan.client.hotrod.server_list", "localhost:" + hotRodServer2.getPort() + ";localhost:" + hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "true");
        props.put("timeBetweenEvictionRunsMillis", "500");
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(props)){

            @Override
            public void call() throws Exception {
                TcpTransportFactory tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.rcm, (String)"transportFactory");
                for (int i = 0; i < 10 && tcpConnectionFactory.getServers().size() == 1; ++i) {
                    Thread.sleep(1000L);
                }
                AssertJUnit.assertEquals((int)2, (int)tcpConnectionFactory.getServers().size());
            }
        });
    }

    public void testTopologyNotFetched() throws Exception {
        Properties props = new Properties();
        HotRodServer hotRodServer2 = this.server(1);
        props.put("infinispan.client.hotrod.server_list", "localhost:" + hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "false");
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(props)){

            @Override
            public void call() throws Exception {
                TcpTransportFactory tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.rcm, (String)"transportFactory");
                AssertJUnit.assertEquals((int)1, (int)tcpConnectionFactory.getServers().size());
            }
        });
    }

    public void testGetCacheWithPingOnStartupDisabledSingleNode() throws Exception {
        Properties props = new Properties();
        props.put("infinispan.client.hotrod.server_list", "boomoo:12345");
        props.put("infinispan.client.hotrod.ping_on_startup", "false");
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(props)){

            @Override
            public void call() throws Exception {
                this.rcm.getCache();
            }
        });
    }

    public void testGetCacheWithPingOnStartupDisabledMultipleNodes() throws Exception {
        Properties props = new Properties();
        HotRodServer hotRodServer2 = this.server(1);
        props.put("infinispan.client.hotrod.server_list", "boomoo:12345;localhost:" + hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "false");
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(props)){

            @Override
            public void call() throws Exception {
                RemoteCache cache = this.rcm.getCache();
                AssertJUnit.assertFalse((boolean)cache.containsKey((Object)"k"));
            }
        });
    }

    public void testGetCacheWorksIfNodeDown() throws Exception {
        Properties props = new Properties();
        HotRodServer hotRodServer2 = this.server(1);
        props.put("infinispan.client.hotrod.server_list", "boomoo:12345;localhost:" + hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "true");
        props.put("timeBetweenEvictionRunsMillis", "500");
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(props)){

            @Override
            public void call() throws Exception {
                this.rcm.getCache();
            }
        });
    }

    public void testGetCacheWorksIfNodeNotDown() throws Exception {
        Properties props = new Properties();
        HotRodServer hotRodServer2 = this.server(1);
        props.put("infinispan.client.hotrod.server_list", "localhost:" + hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "true");
        props.put("timeBetweenEvictionRunsMillis", "500");
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(props)){

            @Override
            public void call() throws Exception {
                this.rcm.getCache();
            }
        });
    }
}

