/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.BindException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.netty.channel.ChannelException;

public class TestHelper {
    private static final Log log = LogFactory.getLog(TestHelper.class);
    private static final AtomicInteger uniquePort = new AtomicInteger(15232);

    public static HotRodServer startHotRodServer(EmbeddedCacheManager cacheManager) {
        HotRodServer server = null;
        int maxTries = 10;
        int currentTries = 0;
        ChannelException lastException = null;
        while (server == null && currentTries < maxTries) {
            try {
                server = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)cacheManager, (int)uniquePort.incrementAndGet());
            }
            catch (ChannelException e) {
                if (!(e.getCause() instanceof BindException)) {
                    throw e;
                }
                log.debug((Object)("Address already in use: [" + e.getMessage() + "], so let's try next port"));
                ++currentTries;
                lastException = e;
            }
        }
        if (server == null && lastException != null) {
            throw lastException;
        }
        return server;
    }

    public static String getServersString(HotRodServer ... servers) {
        StringBuilder builder = new StringBuilder();
        for (HotRodServer server : servers) {
            builder.append("localhost").append(':').append(server.getPort()).append(";");
        }
        return builder.toString();
    }

    public static Configuration getMultiNodeConfig() {
        Configuration result = new Configuration();
        result.setCacheMode(Configuration.CacheMode.DIST_SYNC);
        result.setSyncReplTimeout(10000L);
        result.setSyncCommitPhase(true);
        result.setSyncRollbackPhase(true);
        return result;
    }
}

