/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.CacheException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ClientSocketReadTimeoutTest", groups={"functional"})
public class ClientSocketReadTimeoutTest
extends SingleCacheManagerTest {
    HotRodServer hotrodServer;
    RemoteCacheManager remoteCacheManager;
    CountDownLatch latch;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.latch = new CountDownLatch(1);
        this.cacheManager = new HangingCacheManager(TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration()), this.latch);
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        this.log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        this.remoteCacheManager = this.getRemoteCacheManager();
        return this.cacheManager;
    }

    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServers("127.0.0.1:" + this.hotrodServer.getPort()).socketTimeout(5000).connectionTimeout(5000).connectionPool().maxActive(2).maxRetries(0);
        return new RemoteCacheManager(builder.create());
    }

    protected void teardown() {
        this.latch.countDown();
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        super.teardown();
    }

    @Test(expectedExceptions={SocketTimeoutException.class})
    public void testPutTimeout(Method m) throws Throwable {
        try {
            assert (null == this.remoteCacheManager.getCache().put((Object)TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m)));
        }
        catch (TransportException e) {
            throw e.getCause();
        }
    }

    private static class HangingCacheManager
    extends AbstractDelegatingEmbeddedCacheManager {
        static Log log = LogFactory.getLog(HangingCacheManager.class);
        final CountDownLatch latch;

        public HangingCacheManager(EmbeddedCacheManager delegate, CountDownLatch latch) {
            super(delegate);
            this.latch = latch;
        }

        public <K, V> Cache<K, V> getCache(String cacheName) {
            log.info((Object)"Retrieve cache from hanging cache manager");
            String threadName = Thread.currentThread().getName();
            if (threadName.startsWith("HotRod")) {
                log.info((Object)"Thread is a HotRod server worker thread, so force wait");
                try {
                    this.latch.await(180L, TimeUnit.SECONDS);
                    log.info((Object)"Wait finished, return the cache");
                    return super.getCache();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CacheException((Throwable)e);
                }
            }
            return super.getCache(cacheName);
        }
    }
}

