/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashV1;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash2;
import org.infinispan.commons.util.Util;
import org.jboss.logging.BasicLogger;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ConsistentHashComparisonTest")
public class ConsistentHashComparisonTest {
    public static final int PHISYCAL_NODES = 10;
    public static final int VIRTUAL_NODES = 5;
    private LinkedHashMap<SocketAddress, Set<Integer>> ch;
    CustomRandom customRandom = new CustomRandom();
    ConsistentHashV1Old vOld = new ConsistentHashV1Old(this.customRandom);
    ConsistentHashV1 vNew = new ConsistentHashV1((Random)this.customRandom);

    @BeforeTest
    public void init() {
        int hashSpace = Integer.MAX_VALUE;
        int share = hashSpace / 10;
        int virtualNodesSpan = share / 5 - 1;
        this.ch = new LinkedHashMap();
        for (int i = 0; i < 10; ++i) {
            HashSet<Integer> virtualNodes = new HashSet<Integer>();
            for (int j = 0; j < 5; ++j) {
                virtualNodes.add(share * i + virtualNodesSpan * j);
            }
            this.ch.put(new InetSocketAddress(i), virtualNodes);
        }
        this.vOld.init(this.ch, 2, Integer.MAX_VALUE);
        this.vNew.init(this.ch, 2, Integer.MAX_VALUE);
    }

    public void testSameValues() {
        for (int i = 0; i < 1000; ++i) {
            byte[] key = String.valueOf(i).getBytes();
            Assert.assertEquals((Object)this.vOld.getServer(key), (Object)this.vNew.getServer((Object)key), (String)("int value is " + i));
        }
    }

    public void testSameValues2() {
        Random rnd = new Random();
        for (int i = 0; i < 10000; ++i) {
            byte[] key = new byte[i + 1];
            rnd.nextBytes(key);
            Assert.assertEquals((Object)this.vOld.getServer(key), (Object)this.vNew.getServer((Object)key), (String)("int value is " + i));
        }
    }

    public void testIsolatedValue() {
        byte[] key = String.valueOf(0).getBytes();
        SocketAddress newOne = this.vNew.getServer((Object)key);
        SocketAddress oldOne = this.vOld.getServer(key);
        Assert.assertEquals((Object)oldOne, (Object)newOne);
    }

    public void testIsolatedValue2() {
        byte[] key = String.valueOf(7).getBytes();
        SocketAddress newOne = this.vNew.getServer((Object)key);
        SocketAddress oldOne = this.vOld.getServer(key);
        Assert.assertEquals((Object)oldOne, (Object)newOne);
    }

    static class ConsistentHashV1Old
    implements ConsistentHash {
        private static final BasicLogger log = LogFactory.getLog(ConsistentHashV1Old.class);
        private final SortedMap<Integer, SocketAddress> positions = new TreeMap<Integer, SocketAddress>();
        private int hashSpace;
        protected Hash hash = new MurmurHash2();
        private int numKeyOwners;
        private final Random rnd;

        public ConsistentHashV1Old(Random rnd) {
            this.rnd = rnd;
        }

        public ConsistentHashV1Old() {
            this(new Random());
        }

        public void init(Map<SocketAddress, Set<Integer>> servers2Hash, int numKeyOwners, int hashSpace) {
            log.infof("Parameters received by CH are: server2Hash: %s, numKeyOwners: %s, hashSpace: %s", servers2Hash, (Object)numKeyOwners, (Object)hashSpace);
            for (Map.Entry<SocketAddress, Set<Integer>> entry : servers2Hash.entrySet()) {
                SocketAddress addr = entry.getKey();
                for (Integer hash : entry.getValue()) {
                    SocketAddress prev = this.positions.put(hash, addr);
                    if (prev == null) continue;
                    log.debugf("Adding hash (%d) again, this time for %s. Previously it was associated with: %s", (Object)hash, (Object)addr, (Object)prev);
                }
            }
            log.tracef("Positions (%d entries) are: %s", this.positions.size(), this.positions);
            this.hashSpace = hashSpace;
            this.numKeyOwners = numKeyOwners;
        }

        public SocketAddress getServer(Object key) {
            int keyHashCode = this.getNormalizedHash(key);
            if (keyHashCode == Integer.MIN_VALUE) {
                ++keyHashCode;
            }
            int hash = Math.abs(keyHashCode);
            SortedMap<Integer, SocketAddress> candidates = this.positions.tailMap(hash % this.hashSpace);
            if (log.isTraceEnabled()) {
                log.tracef("Found possible candidates: %s", candidates);
            }
            return (candidates.size() > 0 ? candidates : this.positions).entrySet().iterator().next().getValue();
        }

        private SocketAddress getItemAtPosition(int position, SortedMap<Integer, SocketAddress> map) {
            Iterator<Map.Entry<Integer, SocketAddress>> iterator = map.entrySet().iterator();
            for (int i = 0; i < position; ++i) {
                iterator.next();
            }
            return iterator.next().getValue();
        }

        public void setHash(Hash hash) {
            this.hash = hash;
        }

        public int getNormalizedHash(Object key) {
            return Util.getNormalizedHash((Object)key, (Hash)this.hash);
        }

        public Map<SocketAddress, Set<Integer>> getSegmentsByServer() {
            return null;
        }
    }

    public static class CustomRandom
    extends Random {
        int callCount = 0;
        int toReturn;

        @Override
        public int nextInt(int val) {
            if (this.callCount % 2 == 0) {
                this.toReturn = super.nextInt(val);
            }
            ++this.callCount;
            return this.toReturn;
        }
    }
}

