/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.GetAllCompatDistTest", groups={"functional"})
public class GetAllCompatDistTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, this.getCacheConfiguration());
    }

    private ConfigurationBuilder getCacheConfiguration() {
        ConfigurationBuilder builder = GetAllCompatDistTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numOwners(1).compatibility().enabled(true);
        return builder;
    }

    public void testGetAllWithCompatibility() {
        RemoteCache cache = this.client(0).getCache();
        HashMap<String, String> cachedValues = new HashMap<String, String>();
        for (int i = 0; i < 100; ++i) {
            String key = String.format("key-%d", i);
            String value = String.format("value-%d", i);
            cache.put((Object)key, (Object)value);
            cachedValues.put(key, value);
        }
        Map values = cache.getAll(cachedValues.keySet());
        AssertJUnit.assertEquals((int)cachedValues.size(), (int)values.size());
        for (String key : values.keySet()) {
            AssertJUnit.assertEquals((String)((String)cachedValues.get(key)), (String)((String)values.get(key)));
        }
    }
}

