/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.client.hotrod.AuthenticationTest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestCallbackHandler;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.SecureExecTest", groups={"functional"})
@CleanupAfterMethod
public class SecureExecTest
extends AuthenticationTest {
    static final Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin", "___script_manager"});
    static final Subject RUNNER = TestingUtil.makeSubject((String[])new String[]{"runner", "runner"});
    static final Subject PHEIDIPPIDES = TestingUtil.makeSubject((String[])new String[]{"pheidippides", "pheidippides"});
    private RemoteCacheManager remoteCacheManager;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper());
        globalRoles.role("runner").permission(AuthorizationPermission.EXEC).permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).permission(AuthorizationPermission.ADMIN).role("pheidippides").permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).permission(AuthorizationPermission.ADMIN).role("admin").permission(AuthorizationPermission.ALL);
        org.infinispan.configuration.cache.ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        config.security().authorization().enable().role("runner").role("pheidippides").role("admin");
        this.cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.getCache();
        return this.cacheManager;
    }

    protected void setup() throws Exception {
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                SecureExecTest.super.setup();
                return null;
            }
        });
    }

    @Override
    protected void teardown() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecureExecTest.super.teardown();
                return null;
            }
        });
    }

    protected void clearContent() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecureExecTest.this.cacheManager.getCache().clear();
                return null;
            }
        });
    }

    @Override
    protected ConfigurationBuilder initServerAndClient() {
        return (ConfigurationBuilder)Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<ConfigurationBuilder>(){

            @Override
            public ConfigurationBuilder run() {
                return SecureExecTest.super.initServerAndClient();
            }
        });
    }

    @Test(enabled=false, description="Disabled until issue ISPN-6210 is fixed.")
    public void testSimpleScriptExecutionWithValidAuth() throws IOException, PrivilegedActionException {
        ConfigurationBuilder clientBuilder = this.initServerAndClient();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("user", "realm", "password".toCharArray()));
        this.runTestWithGivenConfig(clientBuilder.build(), RUNNER);
    }

    @Test(enabled=false, description="Disabled until issue ISPN-6210 is fixed.")
    public void testSimpleScriptExecutionWithInValidAuth() throws IOException, PrivilegedActionException {
        ConfigurationBuilder clientBuilder = this.initServerAndClient();
        clientBuilder.security().authentication().callbackHandler((CallbackHandler)new TestCallbackHandler("user", "realm", "password".toCharArray()));
        this.runTestWithGivenConfig(clientBuilder.build(), PHEIDIPPIDES);
    }

    private void runTestWithGivenConfig(Configuration config, Subject subject) throws IOException, PrivilegedActionException {
        this.remoteCacheManager = new RemoteCacheManager(config);
        final HashMap<String, String> params = new HashMap<String, String>();
        params.put("a", "guinness");
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ScriptingManager scriptingManager = (ScriptingManager)SecureExecTest.this.hotrodServer.getCacheManager().getGlobalComponentRegistry().getComponent(ScriptingManager.class);
                try (InputStream is = this.getClass().getResourceAsStream("/testRole.js");){
                    String script = TestingUtil.loadFileAsString((InputStream)is);
                    scriptingManager.addScript("testRole.js", script);
                }
                return null;
            }
        });
        Security.doAs((Subject)subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Integer result = (Integer)SecureExecTest.this.remoteCacheManager.getCache().execute("testRole.js", params);
                AssertJUnit.assertEquals((Object)"guinness", (Object)SecureExecTest.this.remoteCacheManager.getCache().get((Object)"a"));
                return null;
            }
        });
    }
}

