/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import java.util.Properties;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.BaseCustomInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.SkipIndexingFlagTest", groups={"functional"})
@CleanupAfterTest
public class SkipIndexingFlagTest
extends SingleCacheManagerTest {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private FlagCheckCommandInterceptor commandInterceptor;
    private RemoteCache<String, String> remoteCache;
    private RemoteCacheManager remoteCacheManager;
    private HotRodServer hotRodServer;

    public void testPut() {
        this.performTest(RequestType.PUT);
    }

    public void testReplace() {
        this.performTest(RequestType.REPLACE);
    }

    public void testPutIfAbsent() {
        this.performTest(RequestType.PUT_IF_ABSENT);
    }

    public void testReplaceIfUnmodified() {
        this.performTest(RequestType.REPLACE_IF_UNMODIFIED);
    }

    public void testGet() {
        this.performTest(RequestType.GET);
    }

    public void testGetWithVersion() {
        this.performTest(RequestType.GET_WITH_VERSION);
    }

    public void testGetWithMetadata() {
        this.performTest(RequestType.GET_WITH_METADATA);
    }

    public void testRemove() {
        this.performTest(RequestType.REMOVE);
    }

    public void testRemoveIfUnmodified() {
        this.performTest(RequestType.REMOVE_IF_UNMODIFIED);
    }

    public void testContainsKey() {
        this.performTest(RequestType.CONTAINS);
    }

    public void testPutAll() {
        this.performTest(RequestType.PUT_ALL);
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        Properties hotRodClientConf = new Properties();
        hotRodClientConf.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer.getPort());
        this.remoteCacheManager = new RemoteCacheManager(hotRodClientConf);
        this.remoteCache = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
        super.teardown();
    }

    private void performTest(RequestType type) {
        this.commandInterceptor.expectSkipIndexingFlag = false;
        type.execute(this.remoteCache);
        this.commandInterceptor.expectSkipIndexingFlag = RequestType.expectsFlag(type);
        type.execute((RemoteCache<String, String>)this.remoteCache.withFlags(new Flag[]{Flag.SKIP_INDEXING}));
        type.execute((RemoteCache<String, String>)this.remoteCache.withFlags(new Flag[]{Flag.SKIP_INDEXING, Flag.FORCE_RETURN_VALUE}));
    }

    @BeforeClass(alwaysRun=true)
    private void injectCommandInterceptor() {
        if (this.remoteCache == null) {
            return;
        }
        for (CommandInterceptor commandInterceptor : this.cache.getAdvancedCache().getInterceptorChain()) {
            if (!(commandInterceptor instanceof FlagCheckCommandInterceptor)) continue;
            this.commandInterceptor = (FlagCheckCommandInterceptor)commandInterceptor;
        }
        this.commandInterceptor = new FlagCheckCommandInterceptor();
        this.cache.getAdvancedCache().addInterceptor((CommandInterceptor)this.commandInterceptor, 1);
    }

    @AfterClass(alwaysRun=true)
    private void resetCommandInterceptor() {
        if (this.commandInterceptor != null) {
            this.commandInterceptor.expectSkipIndexingFlag = false;
        }
    }

    private static class FlagCheckCommandInterceptor
    extends BaseCustomInterceptor {
        private volatile boolean expectSkipIndexingFlag;

        private FlagCheckCommandInterceptor() {
        }

        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            if (command instanceof LocalFlagAffectedCommand) {
                boolean hasFlag = ((LocalFlagAffectedCommand)command).hasFlag(org.infinispan.context.Flag.SKIP_INDEXING);
                if (this.expectSkipIndexingFlag && !hasFlag) {
                    throw new CacheException("SKIP_INDEXING flag is expected!");
                }
                if (!this.expectSkipIndexingFlag && hasFlag) {
                    throw new CacheException("SKIP_INDEXING flag is *not* expected!");
                }
            }
            return super.handleDefault(ctx, command);
        }
    }

    private static enum RequestType {
        PUT{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.put((Object)SkipIndexingFlagTest.KEY, (Object)SkipIndexingFlagTest.VALUE);
            }
        }
        ,
        REPLACE{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.replace((Object)SkipIndexingFlagTest.KEY, (Object)SkipIndexingFlagTest.VALUE);
            }
        }
        ,
        PUT_IF_ABSENT{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.putIfAbsent((Object)SkipIndexingFlagTest.KEY, (Object)SkipIndexingFlagTest.VALUE);
            }
        }
        ,
        REPLACE_IF_UNMODIFIED{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.replaceWithVersion((Object)SkipIndexingFlagTest.KEY, (Object)SkipIndexingFlagTest.VALUE, 0L);
            }
        }
        ,
        GET{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.get((Object)SkipIndexingFlagTest.KEY);
            }
        }
        ,
        GET_WITH_VERSION{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.getVersioned((Object)SkipIndexingFlagTest.KEY);
            }
        }
        ,
        GET_WITH_METADATA{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.getWithMetadata((Object)SkipIndexingFlagTest.KEY);
            }
        }
        ,
        REMOVE{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.remove((Object)SkipIndexingFlagTest.KEY);
            }
        }
        ,
        REMOVE_IF_UNMODIFIED{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.removeWithVersion((Object)SkipIndexingFlagTest.KEY, 0L);
            }
        }
        ,
        CONTAINS{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.containsKey((Object)SkipIndexingFlagTest.KEY);
            }
        }
        ,
        PUT_ALL{

            @Override
            void execute(RemoteCache<String, String> cache) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put(SkipIndexingFlagTest.KEY, SkipIndexingFlagTest.VALUE);
                cache.putAll(data);
            }
        };


        private static boolean expectsFlag(RequestType type) {
            return type != CONTAINS && type != GET && type != GET_WITH_METADATA && type != GET_WITH_VERSION;
        }

        abstract void execute(RemoteCache<String, String> var1);
    }
}

