/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.Arrays;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.client.hotrod.SomeAsyncExecutorFactory;
import org.infinispan.client.hotrod.SomeCustomConsistentHashV1;
import org.infinispan.client.hotrod.SomeRequestBalancingStrategy;
import org.infinispan.client.hotrod.SomeTransportfactory;
import org.infinispan.client.hotrod.configuration.ClusterConfiguration;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.impl.transport.tcp.SaslTransportObjectFactory;
import org.infinispan.commons.CacheConfigurationException;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.configuration.ConfigurationTest", groups={"functional"})
public class ConfigurationTest {
    public void testConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("host1").port(11222).addServer().host("host2").port(11222).asyncExecutorFactory().factoryClass(SomeAsyncExecutorFactory.class).balancingStrategy(SomeRequestBalancingStrategy.class).connectionPool().maxActive(100).maxTotal(150).maxWait(1000L).maxIdle(20).minIdle(10).exhaustedAction(ExhaustedAction.WAIT).numTestsPerEvictionRun(5).testOnBorrow(true).testOnReturn(true).testWhileIdle(false).minEvictableIdleTime(12000L).timeBetweenEvictionRuns(15000L).connectionTimeout(100).consistentHashImpl(1, SomeCustomConsistentHashV1.class).socketTimeout(100).tcpNoDelay(false).pingOnStartup(false).keySizeEstimate(128).valueSizeEstimate(1024).maxRetries(0).tcpKeepAlive(true).transportFactory(SomeTransportfactory.class).addJavaSerialWhiteList(new String[]{".*Person.*", ".*Employee.*"});
        Configuration configuration = builder.build();
        this.validateConfiguration(configuration);
        ConfigurationBuilder newBuilder = new ConfigurationBuilder();
        newBuilder.read(configuration);
        Configuration newConfiguration = newBuilder.build();
        this.validateConfiguration(newConfiguration);
    }

    public void testParseServerAddresses() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServers("1.1.1.1:9999");
        builder.addServers("2.2.2.2");
        builder.addServers("[fe80::290:bff:fe1b:5762]:7777");
        builder.addServers("[ff01::1]");
        builder.addServers("localhost");
        builder.addServers("localhost:8382");
        Configuration cfg = builder.build();
        this.assertServer("1.1.1.1", 9999, (ServerConfiguration)cfg.servers().get(0));
        this.assertServer("2.2.2.2", 11222, (ServerConfiguration)cfg.servers().get(1));
        this.assertServer("fe80::290:bff:fe1b:5762", 7777, (ServerConfiguration)cfg.servers().get(2));
        this.assertServer("ff01::1", 11222, (ServerConfiguration)cfg.servers().get(3));
        this.assertServer("localhost", 11222, (ServerConfiguration)cfg.servers().get(4));
        this.assertServer("localhost", 8382, (ServerConfiguration)cfg.servers().get(5));
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Invalid max_retries \\(value=-1\\). Value should be greater or equal than zero.")
    public void testNegativeRetriesPerServer() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.maxRetries(-1);
        builder.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testMissingClusterNameDefinition() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addCluster(null);
        builder.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testMissingHostDefinition() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addCluster("test").addClusterNode(null, 1234);
        builder.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testMissingClusterServersDefinition() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addCluster("test");
        builder.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testDuplicateClusterDefinition() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addCluster("test").addClusterNode("host1", 1234);
        builder.addCluster("test").addClusterNode("host1", 5678);
        builder.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testInvalidAuthenticationConfig() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().authentication().enable().saslMechanism("PLAIN");
        builder.build();
    }

    public void testValidAuthenticationSubjectNoCBH() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().authentication().enable().saslMechanism("PLAIN").clientSubject(new Subject());
        builder.build();
    }

    public void testValidAuthenticationCBHNoSubject() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().authentication().enable().saslMechanism("PLAIN").callbackHandler((CallbackHandler)SaslTransportObjectFactory.NoOpCallbackHandler.INSTANCE);
        builder.build();
    }

    public void testClusters() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServers("1.1.1.1:9999");
        builder.addCluster("my-cluster").addClusterNode("localhost", 8382);
        Configuration cfg = builder.build();
        AssertJUnit.assertEquals((int)1, (int)cfg.servers().size());
        this.assertServer("1.1.1.1", 9999, (ServerConfiguration)cfg.servers().get(0));
        AssertJUnit.assertEquals((int)1, (int)cfg.clusters().size());
        AssertJUnit.assertEquals((int)1, (int)((ClusterConfiguration)cfg.clusters().get(0)).getCluster().size());
        this.assertServer("localhost", 8382, (ServerConfiguration)((ClusterConfiguration)cfg.clusters().get(0)).getCluster().get(0));
    }

    private void assertServer(String host, int port, ServerConfiguration serverCfg) {
        AssertJUnit.assertEquals((String)host, (String)serverCfg.host());
        AssertJUnit.assertEquals((int)port, (int)serverCfg.port());
    }

    private void validateConfiguration(Configuration configuration) {
        AssertJUnit.assertEquals((int)2, (int)configuration.servers().size());
        AssertJUnit.assertEquals(SomeAsyncExecutorFactory.class, (Object)configuration.asyncExecutorFactory().factoryClass());
        AssertJUnit.assertEquals(SomeRequestBalancingStrategy.class, (Object)configuration.balancingStrategyClass());
        AssertJUnit.assertEquals(SomeTransportfactory.class, (Object)configuration.transportFactory());
        AssertJUnit.assertEquals(SomeCustomConsistentHashV1.class, (Object)configuration.consistentHashImpl(1));
        AssertJUnit.assertEquals((int)100, (int)configuration.connectionPool().maxActive());
        AssertJUnit.assertEquals((int)150, (int)configuration.connectionPool().maxTotal());
        AssertJUnit.assertEquals((long)1000L, (long)configuration.connectionPool().maxWait());
        AssertJUnit.assertEquals((int)20, (int)configuration.connectionPool().maxIdle());
        AssertJUnit.assertEquals((int)10, (int)configuration.connectionPool().minIdle());
        AssertJUnit.assertEquals((Object)ExhaustedAction.WAIT, (Object)configuration.connectionPool().exhaustedAction());
        AssertJUnit.assertEquals((int)5, (int)configuration.connectionPool().numTestsPerEvictionRun());
        AssertJUnit.assertEquals((long)15000L, (long)configuration.connectionPool().timeBetweenEvictionRuns());
        AssertJUnit.assertEquals((long)12000L, (long)configuration.connectionPool().minEvictableIdleTime());
        AssertJUnit.assertTrue((boolean)configuration.connectionPool().testOnBorrow());
        AssertJUnit.assertTrue((boolean)configuration.connectionPool().testOnReturn());
        AssertJUnit.assertFalse((boolean)configuration.connectionPool().testWhileIdle());
        AssertJUnit.assertEquals((int)100, (int)configuration.connectionTimeout());
        AssertJUnit.assertEquals((int)100, (int)configuration.socketTimeout());
        AssertJUnit.assertFalse((boolean)configuration.tcpNoDelay());
        AssertJUnit.assertTrue((boolean)configuration.tcpKeepAlive());
        AssertJUnit.assertTrue((boolean)configuration.pingOnStartup());
        AssertJUnit.assertEquals((int)128, (int)configuration.keySizeEstimate());
        AssertJUnit.assertEquals((int)1024, (int)configuration.valueSizeEstimate());
        AssertJUnit.assertEquals((int)0, (int)configuration.maxRetries());
        AssertJUnit.assertEquals(Arrays.asList(".*Person.*", ".*Employee.*"), (Object)configuration.serialWhitelist());
    }
}

