/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.TimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientClusterExpirationEventsTest")
public class ClientClusterExpirationEventsTest
extends MultiHotRodServersTest {
    static final int NUM_SERVERS = 2;
    protected ControlledTimeService ts0;
    protected ControlledTimeService ts1;

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, this.getCacheConfiguration());
        this.injectTimeServices();
    }

    private ConfigurationBuilder getCacheConfiguration() {
        ConfigurationBuilder builder = ClientClusterExpirationEventsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numOwners(1);
        return HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)builder);
    }

    @Override
    protected HotRodServer addHotRodServer(ConfigurationBuilder builder) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(cm, serverBuilder);
        server.addCacheEventConverterFactory("static-converter-factory", (CacheEventConverterFactory)new CustomEventLogListener.StaticConverterFactory());
        server.addCacheEventFilterConverterFactory("filter-converter-factory", (CacheEventFilterConverterFactory)new CustomEventLogListener.FilterConverterFactory());
        this.servers.add(server);
        return server;
    }

    private void injectTimeServices() {
        this.ts0 = new ControlledTimeService(0L);
        TestingUtil.replaceComponent((CacheContainer)this.server(0).getCacheManager(), TimeService.class, (Object)this.ts0, (boolean)true);
        this.ts1 = new ControlledTimeService(0L);
        TestingUtil.replaceComponent((CacheContainer)this.server(1).getCacheManager(), TimeService.class, (Object)this.ts1, (boolean)true);
    }

    public void testSimpleExpired() {
        final Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache remote = ClientClusterExpirationEventsTest.this.client(0).getCache();
                eventListener.expectNoEvents();
                remote.put((Object)key0, (Object)"one", 10L, TimeUnit.MINUTES);
                eventListener.expectOnlyCreatedEvent(key0, ClientClusterExpirationEventsTest.this.cache(0));
                ClientClusterExpirationEventsTest.this.ts0.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
                AssertJUnit.assertNull((Object)remote.get((Object)key0));
                eventListener.expectOnlyExpiredEvent(key0, ClientClusterExpirationEventsTest.this.cache(0));
            }
        });
    }

    public void testFilteringInCluster() {
        final Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        final Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        for (HotRodServer server : this.servers) {
            server.addCacheEventFilterFactory("static-filter-factory", (CacheEventFilterFactory)new EventLogListener.StaticCacheEventFilterFactory(key1));
        }
        final EventLogListener.StaticFilteredEventLogListener eventListener = new EventLogListener.StaticFilteredEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache remote = ClientClusterExpirationEventsTest.this.client(0).getCache();
                eventListener.expectNoEvents();
                remote.put((Object)key0, (Object)"one", 10L, TimeUnit.MINUTES);
                eventListener.expectNoEvents();
                remote.put((Object)key1, (Object)"two", 10L, TimeUnit.MINUTES);
                eventListener.expectOnlyCreatedEvent(key1, ClientClusterExpirationEventsTest.this.cache(1));
                ClientClusterExpirationEventsTest.this.ts0.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
                ClientClusterExpirationEventsTest.this.ts1.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
                AssertJUnit.assertNull((Object)remote.get((Object)key0));
                eventListener.expectNoEvents();
                AssertJUnit.assertNull((Object)remote.get((Object)key1));
                eventListener.expectOnlyExpiredEvent(key1, ClientClusterExpirationEventsTest.this.cache(1));
            }
        });
    }

    public void testConversionInCluster() {
        final Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        final Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        final CustomEventLogListener.StaticCustomEventLogListener eventListener = new CustomEventLogListener.StaticCustomEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache c3 = ClientClusterExpirationEventsTest.this.client(0).getCache();
                eventListener.expectNoEvents();
                c3.put((Object)key0, (Object)"one", 10L, TimeUnit.MINUTES);
                eventListener.expectCreatedEvent(new CustomEventLogListener.CustomEvent(key0, "one", 0));
                c3.put((Object)key1, (Object)"two", 10L, TimeUnit.MINUTES);
                eventListener.expectCreatedEvent(new CustomEventLogListener.CustomEvent(key1, "two", 0));
                ClientClusterExpirationEventsTest.this.ts0.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
                ClientClusterExpirationEventsTest.this.ts1.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
                AssertJUnit.assertNull((Object)c3.get((Object)key0));
                eventListener.expectExpiredEvent(new CustomEventLogListener.CustomEvent(key0, "one", 0));
                AssertJUnit.assertNull((Object)c3.get((Object)key1));
                eventListener.expectExpiredEvent(new CustomEventLogListener.CustomEvent(key1, "two", 0));
            }
        });
    }

    public void testFilterCustomEventsInCluster() {
        final Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        final Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        final CustomEventLogListener.FilterCustomEventLogListener eventListener = new CustomEventLogListener.FilterCustomEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new Object[]{key0}, null, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache remote = ClientClusterExpirationEventsTest.this.client(0).getCache();
                remote.put((Object)key0, (Object)"one", 10L, TimeUnit.MINUTES);
                eventListener.expectCreatedEvent(new CustomEventLogListener.CustomEvent(key0, null, 1));
                remote.put((Object)key1, (Object)"two", 10L, TimeUnit.MINUTES);
                eventListener.expectCreatedEvent(new CustomEventLogListener.CustomEvent(key1, "two", 1));
                ClientClusterExpirationEventsTest.this.ts0.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
                ClientClusterExpirationEventsTest.this.ts1.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
                AssertJUnit.assertNull((Object)remote.get((Object)key0));
                eventListener.expectExpiredEvent(new CustomEventLogListener.CustomEvent(key0, null, 2));
                AssertJUnit.assertNull((Object)remote.get((Object)key1));
                eventListener.expectExpiredEvent(new CustomEventLogListener.CustomEvent(key1, "two", 2));
            }
        });
    }

    public void testNullValueMetadataExpiration() {
        final Integer key = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                Cache cache0 = ClientClusterExpirationEventsTest.this.cache(0);
                CacheNotifier notifier = (CacheNotifier)cache0.getAdvancedCache().getComponentRegistry().getComponent(CacheNotifier.class);
                byte[] keyBytes = HotRodClientTestingUtil.toBytes(key);
                notifier.notifyCacheEntryExpired((Object)keyBytes, null, null, null);
                eventListener.expectOnlyExpiredEvent(key, ClientClusterExpirationEventsTest.this.cache(0));
            }
        });
    }
}

