/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.Serializable;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.filter.NamedFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientEventsOOMTest")
public class ClientEventsOOMTest
extends MultiHotRodServersTest {
    private static final int NUM_ENTRIES = Integer.getInteger("client.stress.num_entries", 1000);
    private static final long SLEEP_TIME = Long.getLong("client.stress.sleep_time", 10L);
    private static final int NUM_NODES = 2;
    private static final int NUM_OWNERS = 1;
    private static BufferPoolMXBean DIRECT_POOL = ClientEventsOOMTest.getDirectMemoryPool();
    private RemoteCache<Integer, byte[]> remoteCache;
    private static final byte[] GODZILLA = ClientEventsOOMTest.makeGodzilla();

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfgBuilder = this.getConfigurationBuilder();
        this.createHotRodServers(2, cfgBuilder);
        this.waitForClusterToForm();
        for (int i = 0; i < 2; ++i) {
            this.server(i).addCacheEventConverterFactory("godzilla-growing-converter-factory", (CacheEventConverterFactory)new CustomConverterFactory());
        }
        this.remoteCache = this.client(0).getCache();
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder builder = ClientEventsOOMTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numOwners(1);
        builder.clustering().sync().replTimeout(5L, TimeUnit.MINUTES);
        return HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)builder);
    }

    public void testOOM() throws Throwable {
        try {
            this.log.debugf("Max direct memory is: %s%n", (Object)ClientEventsOOMTest.humanReadableByteCount(ClientEventsOOMTest.maxDirectMemory0(), false));
            ClientEventsOOMTest.logDirectMemory(this.log);
            byte[] babyGodzilla = new byte[]{13};
            for (int i = 0; i < NUM_ENTRIES; ++i) {
                this.remoteCache.put((Object)i, (Object)babyGodzilla);
            }
            this.log.debugf("ADDED %d BABY GODZILLAS\n", NUM_ENTRIES);
            this.log.debugf("ADDING LISTENER!", new Object[0]);
            CountDownLatch latch = new CountDownLatch(1);
            ClientEntryListener listener = new ClientEntryListener(latch);
            ClientEventsOOMTest.logDirectMemory(this.log);
            this.remoteCache.addClientListener((Object)listener);
            this.log.debugf("ADDED LISTENER", new Object[0]);
            ClientEventsOOMTest.logDirectMemory(this.log);
            latch.await(1L, TimeUnit.MINUTES);
            this.remoteCache.removeClientListener((Object)listener);
            Assert.assertEquals((long)NUM_ENTRIES, (long)listener.eventCount);
        }
        catch (Throwable t) {
            this.log.debug((Object)"Exception reported, direct memory usage is:", t);
            ClientEventsOOMTest.logDirectMemory(this.log);
            throw t;
        }
    }

    private static void logDirectMemory(Log log) {
        log.debugf("Direct memory: used=%s, capacity=%s%n", (Object)ClientEventsOOMTest.humanReadableByteCount(DIRECT_POOL.getMemoryUsed(), false), (Object)ClientEventsOOMTest.humanReadableByteCount(DIRECT_POOL.getTotalCapacity(), false));
    }

    private static BufferPoolMXBean getDirectMemoryPool() {
        List<BufferPoolMXBean> pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        BufferPoolMXBean directPool = null;
        for (BufferPoolMXBean pool : pools) {
            if (!pool.getName().equals("direct")) continue;
            directPool = pool;
        }
        return directPool;
    }

    private static long maxDirectMemory0() {
        try {
            Class<?> vmClass = Class.forName("sun.misc.VM", true, ClassLoader.getSystemClassLoader());
            Method m = vmClass.getDeclaredMethod("maxDirectMemory", new Class[0]);
            return ((Number)m.invoke(null, new Object[0])).longValue();
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    private static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    private static byte[] makeGodzilla() {
        byte[] godzilla = new byte[0x2A00000];
        Arrays.fill(godzilla, (byte)13);
        return godzilla;
    }

    @NamedFactory(name="godzilla-growing-converter-factory")
    private static class CustomConverterFactory
    implements CacheEventConverterFactory {
        private CustomConverterFactory() {
        }

        public <K, V, C> CacheEventConverter<K, V, C> getConverter(Object[] params) {
            return new CustomConverter();
        }

        static class CustomConverter<K, V, C>
        implements CacheEventConverter<K, V, C>,
        Serializable {
            CustomConverter() {
            }

            public C convert(Object key, Object previousValue, Metadata previousMetadata, Object value, Metadata metadata, EventType eventType) {
                return (C)GODZILLA;
            }
        }
    }

    @ClientListener(converterFactoryName="godzilla-growing-converter-factory", useRawData=true, includeCurrentState=true)
    private static class ClientEntryListener {
        private static final Log log = LogFactory.getLog(ClientEntryListener.class);
        private final CountDownLatch latch;
        int eventCount = 0;

        ClientEntryListener(CountDownLatch latch) {
            this.latch = latch;
        }

        @ClientCacheEntryCreated
        public void handleClientCacheEntryCreatedEvent(ClientCacheEntryCustomEvent event) {
            int length = ((byte[])event.getEventData()).length;
            ++this.eventCount;
            log.debugf("ClientEntryListener.handleClientCacheEntryCreatedEvent eventCount=%d length=%d\n", this.eventCount, length);
            ClientEventsOOMTest.logDirectMemory(ClientEntryListener.log);
            if (this.eventCount == NUM_ENTRIES) {
                this.latch.countDown();
            }
            try {
                Thread.sleep(SLEEP_TIME);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

