/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientListenerLifecycleTest")
public class ClientListenerLeakTest
extends SingleHotRodServerTest {
    private String cacheName;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = super.createCacheManager();
        ConfigurationBuilder cfg = HotRodTestingUtil.hotRodCacheConfiguration();
        this.cacheName = ((Object)((Object)this)).getClass().getSimpleName();
        cm.defineConfiguration(this.cacheName, cfg.build());
        cm.getCache(this.cacheName);
        return cm;
    }

    public void testNoLeaksAfterShutdown() {
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(this.getRemoteCacheManager()){

            @Override
            public void call() {
                RemoteCache remote = this.rcm.getCache(ClientListenerLeakTest.this.cacheName);
                EventLogListener<Integer> eventListener = new EventLogListener<Integer>();
                remote.addClientListener(eventListener);
                eventListener.expectNoEvents();
                remote.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedEvent(1, ClientListenerLeakTest.this.cache(ClientListenerLeakTest.this.cacheName));
            }
        });
        TestingUtil.detectThreadLeaks((String)".*Client-Listener-ClientListenerLeakTest-.*");
    }
}

