/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.iteration.BaseMultiServerRemoteIteratorTest;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.impl.iteration.PreferredServerBalancingStrategy;
import org.infinispan.client.hotrod.impl.iteration.RemoteCloseableIterator;
import org.infinispan.client.hotrod.impl.transport.tcp.FailoverRequestBalancingStrategy;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.iteration.MultiServerDistRemoteIteratorTest")
public class MultiServerDistRemoteIteratorTest
extends BaseMultiServerRemoteIteratorTest {
    private static final int NUM_SERVERS = 3;

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(3, this.getCacheConfiguration());
    }

    private org.infinispan.configuration.cache.ConfigurationBuilder getCacheConfiguration() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)MultiServerDistRemoteIteratorTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.clustering().hash().numSegments(60).numOwners(2);
        return builder;
    }

    public void testSegmentFinishedCallback() {
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(20, this::newAccount, cache);
        TestSegmentKeyTracker testSegmentKeyTracker = new TestSegmentKeyTracker();
        try (CloseableIterator iterator = cache.retrieveEntries(null, 3);){
            TestingUtil.replaceField((Object)testSegmentKeyTracker, (String)"segmentKeyTracker", (Object)iterator, RemoteCloseableIterator.class);
            while (iterator.hasNext()) {
                iterator.next();
            }
            Assert.assertEquals((int)60, (int)testSegmentKeyTracker.finished.size());
        }
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(serverPort).maxRetries(this.maxRetries()).balancingStrategy((FailoverRequestBalancingStrategy)new PreferredServerBalancingStrategy(InetSocketAddress.createUnresolved("localhost", serverPort))).pingOnStartup(false);
        return clientBuilder;
    }

    @Test
    public void testIterationRouting() throws Exception {
        for (int i = 0; i < this.clients.size(); ++i) {
            RemoteCacheManager client = this.client(i);
            try (CloseableIterator ignored = client.getCache().retrieveEntries(null, 10);){
                this.assertIterationActiveOnlyOnServer(i);
                continue;
            }
        }
    }

    private void assertIterationActiveOnlyOnServer(int index) {
        for (int i = 0; i < this.servers.size(); ++i) {
            int activeIterations = this.server(i).iterationManager().activeIterations();
            if (i == index) {
                Assert.assertEquals((long)1L, (long)activeIterations);
                continue;
            }
            Assert.assertEquals((long)0L, (long)activeIterations);
        }
    }

    private static class TestSegmentKeyTracker
    implements KeyTracker {
        List<Integer> finished = new ArrayList<Integer>();

        private TestSegmentKeyTracker() {
        }

        public boolean track(byte[] key, short status, List<String> whitelist) {
            return true;
        }

        public void segmentsFinished(byte[] finishedSegments) {
            BitSet bitSet = BitSet.valueOf(finishedSegments);
            bitSet.stream().forEach(this.finished::add);
        }

        public Set<Integer> missedSegments() {
            return null;
        }
    }
}

