/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.iteration.AbstractRemoteIteratorTest;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AccountPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.iteration.ProtobufRemoteIteratorTest")
public class ProtobufRemoteIteratorTest
extends MultiHotRodServersTest
implements AbstractRemoteIteratorTest {
    private static final int NUM_NODES = 2;
    public static final int CACHE_SIZE = 10;

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cfgBuilder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)ProtobufRemoteIteratorTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        this.createHotRodServers(2, cfgBuilder);
        this.waitForClusterToForm();
        RemoteCache metadataCache = this.client(0).getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.read((InputStream)Util.getResourceAsStream((String)"/sample_bank_account/bank.proto", (ClassLoader)this.getClass().getClassLoader())));
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        CustomProtoStreamMarshaller marshaller = new CustomProtoStreamMarshaller();
        this.servers.forEach(s -> s.setMarshaller((Marshaller)marshaller));
        MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.client(0)));
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        return super.createHotRodClientConfigurationBuilder(serverPort).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    public void testSimpleIteration() {
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(10, this::newAccountPB, cache);
        ArrayList results = new ArrayList();
        cache.retrieveEntries(null, null, 10).forEachRemaining(e -> results.add((AccountPB)e.getValue()));
        Assert.assertEquals((int)10, (int)results.size());
    }

    public void testFilteredIteration() {
        this.servers.forEach(s -> s.addKeyValueFilterConverterFactory("filterName", (KeyValueFilterConverterFactory)new ToStringFilterConverterFactory()));
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(10, this::newAccountPB, cache);
        Set segments = this.rangeAsSet(1, 30);
        HashSet results = new HashSet();
        cache.retrieveEntries("filterName", segments, 10).forEachRemaining(results::add);
        Set values = this.extractValues(results);
        this.assertForAll(values, s -> s instanceof String);
        Marshaller marshaller = ((RemoteCacheManager)this.clients.iterator().next()).getMarshaller();
        ConsistentHash consistentHash = this.advancedCache(0).getDistributionManager().getConsistentHash();
        this.assertKeysInSegment(results, segments, marshaller, arg_0 -> ((ConsistentHash)consistentHash).getSegment(arg_0));
    }

    public void testFilteredIterationWithQuery() {
        RemoteCache remoteCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(10, this::newAccountPB, remoteCache);
        QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)remoteCache);
        int lowerId = 5;
        int higherId = 8;
        Query simpleQuery = queryFactory.from(AccountPB.class).having("id").between((Object)lowerId, (Object)higherId).toBuilder().build();
        Set entries = this.extractEntries(remoteCache.retrieveEntriesByQuery(simpleQuery, null, 10));
        Set keys = this.extractKeys(entries);
        Assert.assertEquals((int)4, (int)keys.size());
        this.assertForAll(keys, key -> key >= lowerId && key <= higherId);
        this.assertForAll(entries, e -> e.getValue() instanceof AccountPB);
        Query projectionsQuery = queryFactory.from(AccountPB.class).select(new String[]{"id", "description"}).having("id").between((Object)lowerId, (Object)higherId).toBuilder().build();
        Set entriesWithProjection = this.extractEntries(remoteCache.retrieveEntriesByQuery(projectionsQuery, null, 10));
        Assert.assertEquals((int)4, (int)entriesWithProjection.size());
        this.assertForAll(entriesWithProjection, entry -> {
            Integer id = (Integer)entry.getKey();
            Object[] value = (Object[])entry.getValue();
            return value[0] == id && value[1].equals("description for " + id);
        });
    }

    static final class ToStringFilterConverter
    extends AbstractKeyValueFilterConverter<Integer, AccountPB, String>
    implements Serializable {
        ToStringFilterConverter() {
        }

        public String filterAndConvert(Integer key, AccountPB value, Metadata metadata) {
            return value.toString();
        }
    }

    static final class ToStringFilterConverterFactory
    implements KeyValueFilterConverterFactory<Integer, AccountPB, String>,
    Serializable {
        ToStringFilterConverterFactory() {
        }

        public KeyValueFilterConverter<Integer, AccountPB, String> getFilterConverter() {
            return new ToStringFilterConverter();
        }
    }

    public static class CustomProtoStreamMarshaller
    extends ProtoStreamMarshaller {
        public CustomProtoStreamMarshaller() throws IOException {
            MarshallerRegistration.registerMarshallers(this.getSerializationContext());
        }
    }
}

