/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.remote.CompatibilityProtoStreamMarshaller;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.marshall.PrimitiveEmbeddedCompatTest", groups={"functional"})
public class PrimitiveEmbeddedCompatTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = this.createConfigBuilder();
        builder.dataContainer().keyEquivalence((Equivalence)AnyEquivalence.getInstance());
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder createConfigBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.compatibility().enable().marshaller((Marshaller)new CompatibilityProtoStreamMarshaller());
        return builder;
    }

    @AfterTest
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testRemotePutAndGet() {
        this.remotePutAndGet(1, "foo");
        this.remotePutAndGet(1, true);
        this.remotePutAndGet(1, 7);
        this.remotePutAndGet(1, 777L);
        this.remotePutAndGet(1, 0.0);
        this.remotePutAndGet(1, 1.0);
    }

    private void remotePutAndGet(Object key, Object value) {
        this.remoteCache.clear();
        this.remoteCache.put(key, value);
        Object remoteValue = this.remoteCache.get(key);
        Assert.assertEquals((Object)value, (Object)remoteValue);
        Assert.assertEquals((long)1L, (long)this.cache.keySet().size());
        Object localKey = this.cache.keySet().iterator().next();
        Assert.assertEquals((Object)key, (Object)localKey);
        Object localObject = this.cache.get(localKey);
        Assert.assertEquals((Object)value, (Object)localObject);
    }

    public void testEmbeddedPutAndGet() {
        this.embeddedPutAndGet(1, "bar");
        this.embeddedPutAndGet(1, true);
        this.embeddedPutAndGet(1, 7);
        this.embeddedPutAndGet(1, 777L);
        this.embeddedPutAndGet(1, 0.0);
        this.embeddedPutAndGet(1, 1.0);
    }

    private void embeddedPutAndGet(Object key, Object value) {
        this.cache.clear();
        this.cache.put(key, value);
        Assert.assertTrue((boolean)this.cache.keySet().contains(key));
        Object localValue = this.cache.get(key);
        Assert.assertEquals((Object)value, (Object)localValue);
        Assert.assertEquals((long)1L, (long)this.remoteCache.keySet().size());
        Object remoteKey = this.remoteCache.keySet().iterator().next();
        Assert.assertEquals((Object)key, remoteKey);
        Object remoteValue = this.remoteCache.get(remoteKey);
        Assert.assertEquals((Object)value, (Object)remoteValue);
    }
}

