/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import java.util.TreeMap;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.retry.PutAllRetryTest", groups={"functional"})
public class PutAllRetryTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(3, this.getCacheConfiguration());
    }

    private ConfigurationBuilder getCacheConfiguration() {
        ConfigurationBuilder builder = PutAllRetryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numOwners(2);
        return HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)builder);
    }

    @Override
    protected int maxRetries() {
        return 10;
    }

    @Test
    public void testFailOver() throws InterruptedException {
        RemoteCache remoteCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        int size = 1000;
        TreeMap dataMap = new TreeMap();
        IntStream.range(0, size).forEach(num -> dataMap.put(num, "value" + num));
        remoteCache.putAll(dataMap.subMap(0, size / 2));
        HotRodClientTestingUtil.killServers((HotRodServer)this.servers.get(0));
        remoteCache.putAll(dataMap.subMap(size / 2, size));
        AssertJUnit.assertEquals((int)size, (int)remoteCache.size());
    }
}

