/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.test;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;

public abstract class MultiHotRodServersTest
extends MultipleCacheManagersTest {
    protected List<HotRodServer> servers = new ArrayList<HotRodServer>();
    protected List<RemoteCacheManager> clients = new ArrayList<RemoteCacheManager>();

    protected void createHotRodServers(int num, org.infinispan.configuration.cache.ConfigurationBuilder defaultBuilder) {
        int i;
        for (i = 0; i < num; ++i) {
            this.addHotRodServer(defaultBuilder);
        }
        for (i = 0; i < num; ++i) {
            assert (this.manager(i).getCache() != null);
        }
        TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)num);
        for (i = 0; i < num; ++i) {
            TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(i).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        }
        for (i = 0; i < num; ++i) {
            this.clients.add(this.createClient(i));
        }
    }

    protected RemoteCacheManager createClient(int i) {
        return new InternalRemoteCacheManager(this.createHotRodClientConfigurationBuilder(this.server(i).getPort()).build());
    }

    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(serverPort).maxRetries(this.maxRetries());
        return clientBuilder;
    }

    protected int maxRetries() {
        return 0;
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        try {
            for (HotRodServer server : this.servers) {
                HotRodClientTestingUtil.killServers(server);
            }
        }
        finally {
            super.destroy();
        }
    }

    protected HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(cm);
        this.servers.add(server);
        return server;
    }

    protected HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder, int port) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        HotRodServer server = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)cm, (int)port);
        this.servers.add(server);
        return server;
    }

    protected HotRodServer server(int i) {
        return this.servers.get(i);
    }

    protected void killServer(int i) {
        HotRodServer server = this.servers.get(i);
        HotRodClientTestingUtil.killServers(server);
        this.servers.remove(i);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{(EmbeddedCacheManager)this.cacheManagers.get(i)});
        this.cacheManagers.remove(i);
    }

    protected RemoteCacheManager client(int i) {
        return this.clients.get(i);
    }

    protected void defineInAll(String cacheName, org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        for (HotRodServer server : this.servers) {
            server.getCacheManager().defineConfiguration(cacheName, builder.build());
            server.getCacheManager().getCache(cacheName);
        }
    }
}

