/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.Codec10;
import org.infinispan.client.hotrod.impl.protocol.Codec11;
import org.infinispan.client.hotrod.impl.protocol.Codec12;
import org.infinispan.client.hotrod.impl.protocol.Codec13;
import org.infinispan.client.hotrod.impl.protocol.Codec20;
import org.infinispan.client.hotrod.impl.protocol.Codec21;
import org.infinispan.client.hotrod.impl.protocol.Codec22;
import org.infinispan.client.hotrod.impl.protocol.Codec23;
import org.infinispan.client.hotrod.impl.protocol.Codec24;
import org.infinispan.client.hotrod.impl.protocol.Codec25;
import org.infinispan.client.hotrod.impl.protocol.Codec26;

public class CodecFactory {
    private static final Map<String, Codec> codecMap;
    private static final Codec CODEC_10;
    private static final Codec CODEC_11;
    private static final Codec CODEC_12;
    private static final Codec CODEC_13;
    private static final Codec CODEC_20;
    private static final Codec CODEC_21;
    private static final Codec CODEC_22;
    private static final Codec CODEC_23;
    private static final Codec CODEC_24;
    private static final Codec CODEC_25;
    private static final Codec CODEC_26;

    public static boolean isVersionDefined(String version) {
        return codecMap.containsKey(version);
    }

    public static Codec getCodec(String version) {
        if (codecMap.containsKey(version)) {
            return codecMap.get(version);
        }
        throw new IllegalArgumentException("Invalid Hot Rod protocol version");
    }

    static {
        CODEC_10 = new Codec10();
        CODEC_11 = new Codec11();
        CODEC_12 = new Codec12();
        CODEC_13 = new Codec13();
        CODEC_20 = new Codec20();
        CODEC_21 = new Codec21();
        CODEC_22 = new Codec22();
        CODEC_23 = new Codec23();
        CODEC_24 = new Codec24();
        CODEC_25 = new Codec25();
        CODEC_26 = new Codec26();
        codecMap = new HashMap<String, Codec>();
        codecMap.put("1.0", CODEC_10);
        codecMap.put("1.1", CODEC_11);
        codecMap.put("1.2", CODEC_12);
        codecMap.put("1.3", CODEC_13);
        codecMap.put("2.0", CODEC_20);
        codecMap.put("2.1", CODEC_21);
        codecMap.put("2.2", CODEC_22);
        codecMap.put("2.3", CODEC_23);
        codecMap.put("2.4", CODEC_24);
        codecMap.put("2.5", CODEC_25);
        codecMap.put("2.6", CODEC_26);
    }
}

